/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.resources.GetDeviceResource;
import io.intino.cesar.box.resources.GetDevicesResource;
import io.intino.cesar.box.resources.GetProjectsResource;
import io.intino.cesar.box.resources.GetServerResource;
import io.intino.cesar.box.resources.GetServersResource;
import io.intino.cesar.box.resources.GetSystemResource;
import io.intino.cesar.box.resources.GetSystemsResource;
import io.intino.cesar.box.resources.PostDeploySystemResource;
import io.intino.konos.alexandria.rest.AlexandriaSpark;

public class CesarRestResources {
    public static AlexandriaSpark setup(AlexandriaSpark server, CesarBox box) {
        CesarConfiguration.CesarRestConfiguration configuration = box.configuration().cesarRestConfiguration;
        server.route("projects").get(manager -> new GetProjectsResource(box, manager).execute());
        server.route(":project/systems").get(manager -> new GetSystemsResource(box, manager).execute());
        server.route(":project/systems/:system").get(manager -> new GetSystemResource(box, manager).execute());
        server.route("servers").get(manager -> new GetServersResource(box, manager).execute());
        server.route("servers/:server").get(manager -> new GetServerResource(box, manager).execute());
        server.route("devices").get(manager -> new GetDevicesResource(box, manager).execute());
        server.route("devices/:device").get(manager -> new GetDeviceResource(box, manager).execute());
        server.route("deploy").post(manager -> new PostDeploySystemResource(box, manager).execute());
        return server;
    }
}

