/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBox;
import io.intino.konos.alexandria.activity.services.AuthService;
import io.intino.sumus.box.SumusConfiguration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class CesarConfiguration
extends SumusConfiguration {
    CesarRestConfiguration cesarRestConfiguration;
    CesarBotConfiguration cesarBotConfiguration;
    NessConfiguration nessConfiguration;
    InfrastructureOperationConfiguration infrastructureOperationConfiguration;
    ServerStatusConfiguration serverStatusConfiguration;
    ServerLogConfiguration serverLogConfiguration;
    ServerUpgradeConfiguration serverUpgradeConfiguration;
    FeederStatusConfiguration feederStatusConfiguration;
    FeederLogConfiguration feederLogConfiguration;
    FeederUpgradeConfiguration feederUpgradeConfiguration;
    DeviceStatusConfiguration deviceStatusConfiguration;
    DeviceBootConfiguration deviceBootConfiguration;
    DeviceUpgradeConfiguration deviceUpgradeConfiguration;
    DeviceCrashConfiguration deviceCrashConfiguration;
    SystemLogConfiguration systemLogConfiguration;
    SystemStatusConfiguration systemStatusConfiguration;
    CesarActivityConfiguration cesarConfiguration;

    public CesarConfiguration(String[] args) {
        super(args);
        this.fillWithArgs();
    }

    private void fillWithArgs() {
        if (this.store == null && this.args.get("graph_store") != null) {
            this.store = new File((String)this.args.remove("graph_store"));
        }
        if (this.args.containsKey("cesar-rest_port")) {
            this.cesarRestConfiguration(this.toInt((String)this.args.remove("cesar-rest_port")));
        }
        if (this.args.containsKey("cesarBot_token")) {
            this.cesarBotConfiguration((String)this.args.remove("cesarBot_token"));
        }
        if (this.args.containsKey("ness_url")) {
            this.nessConfiguration((String)this.args.remove("ness_url"), (String)this.args.remove("ness_user"), (String)this.args.remove("ness_password"), (String)this.args.remove("ness_clientID"));
        }
        this.setInfrastructureOperationConfiguration();
        this.setServerStatusConfiguration();
        this.setServerLogConfiguration();
        this.setServerUpgradeConfiguration();
        this.setFeederStatusConfiguration();
        this.setFeederLogConfiguration();
        this.setFeederUpgradeConfiguration();
        this.setDeviceStatusConfiguration();
        this.setDeviceBootConfiguration();
        this.setDeviceUpgradeConfiguration();
        this.setDeviceCrashConfiguration();
        this.setSystemLogConfiguration();
        this.setSystemStatusConfiguration();
        if (this.args.containsKey("cesar_port")) {
            this.cesarConfiguration(this.toInt((String)this.args.remove("cesar_port")), (String)this.args.remove("cesar_federationUrl"));
            this.cesarConfiguration.authService = CesarBox.authService(this.cesarConfiguration.authServiceUrl());
        }
    }

    public File store() {
        return this.store;
    }

    public CesarConfiguration cesarRestConfiguration(int port) {
        this.cesarRestConfiguration = new CesarRestConfiguration();
        this.cesarRestConfiguration.port = port;
        this.cesarRestConfiguration.webDirectory = "www/";
        return this;
    }

    public CesarRestConfiguration cesarRestConfiguration() {
        return this.cesarRestConfiguration;
    }

    public CesarConfiguration cesarBotConfiguration(String token) {
        this.cesarBotConfiguration = new CesarBotConfiguration();
        this.cesarBotConfiguration.token = token;
        return this;
    }

    public CesarBotConfiguration cesarBotConfiguration() {
        return this.cesarBotConfiguration;
    }

    public CesarConfiguration nessConfiguration(String url, String user, String password, String clientID) {
        this.nessConfiguration = new NessConfiguration();
        this.nessConfiguration.url = url;
        this.nessConfiguration.user = user;
        this.nessConfiguration.password = password;
        this.nessConfiguration.clientID = clientID;
        return this;
    }

    public NessConfiguration nessConfiguration() {
        return this.nessConfiguration;
    }

    public CesarConfiguration setInfrastructureOperationConfiguration() {
        this.infrastructureOperationConfiguration = new InfrastructureOperationConfiguration();
        return this;
    }

    public InfrastructureOperationConfiguration infrastructureOperationConfiguration() {
        return this.infrastructureOperationConfiguration;
    }

    public CesarConfiguration setServerStatusConfiguration() {
        this.serverStatusConfiguration = new ServerStatusConfiguration();
        return this;
    }

    public ServerStatusConfiguration serverStatusConfiguration() {
        return this.serverStatusConfiguration;
    }

    public CesarConfiguration setServerLogConfiguration() {
        this.serverLogConfiguration = new ServerLogConfiguration();
        return this;
    }

    public ServerLogConfiguration serverLogConfiguration() {
        return this.serverLogConfiguration;
    }

    public CesarConfiguration setServerUpgradeConfiguration() {
        this.serverUpgradeConfiguration = new ServerUpgradeConfiguration();
        return this;
    }

    public ServerUpgradeConfiguration serverUpgradeConfiguration() {
        return this.serverUpgradeConfiguration;
    }

    public CesarConfiguration setFeederStatusConfiguration() {
        this.feederStatusConfiguration = new FeederStatusConfiguration();
        return this;
    }

    public FeederStatusConfiguration feederStatusConfiguration() {
        return this.feederStatusConfiguration;
    }

    public CesarConfiguration setFeederLogConfiguration() {
        this.feederLogConfiguration = new FeederLogConfiguration();
        return this;
    }

    public FeederLogConfiguration feederLogConfiguration() {
        return this.feederLogConfiguration;
    }

    public CesarConfiguration setFeederUpgradeConfiguration() {
        this.feederUpgradeConfiguration = new FeederUpgradeConfiguration();
        return this;
    }

    public FeederUpgradeConfiguration feederUpgradeConfiguration() {
        return this.feederUpgradeConfiguration;
    }

    public CesarConfiguration setDeviceStatusConfiguration() {
        this.deviceStatusConfiguration = new DeviceStatusConfiguration();
        return this;
    }

    public DeviceStatusConfiguration deviceStatusConfiguration() {
        return this.deviceStatusConfiguration;
    }

    public CesarConfiguration setDeviceBootConfiguration() {
        this.deviceBootConfiguration = new DeviceBootConfiguration();
        return this;
    }

    public DeviceBootConfiguration deviceBootConfiguration() {
        return this.deviceBootConfiguration;
    }

    public CesarConfiguration setDeviceUpgradeConfiguration() {
        this.deviceUpgradeConfiguration = new DeviceUpgradeConfiguration();
        return this;
    }

    public DeviceUpgradeConfiguration deviceUpgradeConfiguration() {
        return this.deviceUpgradeConfiguration;
    }

    public CesarConfiguration setDeviceCrashConfiguration() {
        this.deviceCrashConfiguration = new DeviceCrashConfiguration();
        return this;
    }

    public DeviceCrashConfiguration deviceCrashConfiguration() {
        return this.deviceCrashConfiguration;
    }

    public CesarConfiguration setSystemLogConfiguration() {
        this.systemLogConfiguration = new SystemLogConfiguration();
        return this;
    }

    public SystemLogConfiguration systemLogConfiguration() {
        return this.systemLogConfiguration;
    }

    public CesarConfiguration setSystemStatusConfiguration() {
        this.systemStatusConfiguration = new SystemStatusConfiguration();
        return this;
    }

    public SystemStatusConfiguration systemStatusConfiguration() {
        return this.systemStatusConfiguration;
    }

    public CesarConfiguration cesarConfiguration(int port, String federationUrl) {
        this.cesarConfiguration = new CesarActivityConfiguration();
        this.cesarConfiguration.port = port;
        this.cesarConfiguration.webDirectory = "www/";
        this.cesarConfiguration.federationUrl = federationUrl;
        return this;
    }

    public CesarActivityConfiguration cesarConfiguration() {
        return this.cesarConfiguration;
    }

    public static class CesarActivityConfiguration {
        public int port;
        public String webDirectory;
        public AuthService authService;
        public String federationUrl = "";

        public URL authServiceUrl() {
            try {
                if (this.federationUrl == null) {
                    return null;
                }
                return new URL("{federationUrl}".replace("{federationUrl}", this.federationUrl));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }

    public static class SystemStatusConfiguration {
    }

    public static class SystemLogConfiguration {
    }

    public static class DeviceCrashConfiguration {
    }

    public static class DeviceUpgradeConfiguration {
    }

    public static class DeviceBootConfiguration {
    }

    public static class DeviceStatusConfiguration {
    }

    public static class FeederUpgradeConfiguration {
    }

    public static class FeederLogConfiguration {
    }

    public static class FeederStatusConfiguration {
    }

    public static class ServerUpgradeConfiguration {
    }

    public static class ServerLogConfiguration {
    }

    public static class ServerStatusConfiguration {
    }

    public static class InfrastructureOperationConfiguration {
    }

    public static class NessConfiguration {
        public String url;
        public String user;
        public String password;
        public String clientID;
    }

    public static class CesarBotConfiguration {
        public String token;
    }

    public static class CesarRestConfiguration {
        public int port;
        public String webDirectory;
    }
}

