/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.slack.CesarBotSlack;
import io.intino.cesar.box.slack.DeviceSlack;
import io.intino.cesar.box.slack.FeederSlack;
import io.intino.cesar.box.slack.ManageSlack;
import io.intino.cesar.box.slack.ProjectSlack;
import io.intino.cesar.box.slack.ProjectSystemSlack;
import io.intino.cesar.box.slack.ServerSlack;
import io.intino.konos.slack.Bot;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CesarBotSlackBot
extends Bot {
    private static Logger LOG = Logger.getGlobal();
    private CesarBotSlack cesarBotSlack;
    private ManageSlack manageSlack;
    private ProjectSlack projectSlack;
    private DeviceSlack deviceSlack;
    private ServerSlack serverSlack;
    private FeederSlack feederSlack;
    private ProjectSystemSlack projectSystemSlack;

    public CesarBotSlackBot(CesarBox box) {
        super(box.configuration().cesarBotConfiguration().token);
        this.cesarBotSlack = new CesarBotSlack(box);
        this.manageSlack = new ManageSlack(box);
        this.projectSlack = new ProjectSlack(box);
        this.deviceSlack = new DeviceSlack(box);
        this.serverSlack = new ServerSlack(box);
        this.feederSlack = new FeederSlack(box);
        this.projectSystemSlack = new ProjectSystemSlack(box);
        this.add("help", Collections.emptyList(), Collections.emptyList(), "Show this help", (properties, args) -> {
            Map context = this.commandsInfoByContext(((Bot.Context)this.contexts().get(properties.username())).command());
            StringBuilder builder = new StringBuilder();
            context.keySet().forEach(c -> builder.append(CesarBotSlackBot.formatCommand(c, (Bot.CommandInfo)context.get(c))).append("\n"));
            return builder.toString();
        });
        this.add("exit", Collections.emptyList(), Collections.emptyList(), "Exit from current directory", (properties, args) -> {
            Bot.Context context = (Bot.Context)this.contexts().get(properties.username());
            if (context != null) {
                String command = context.command();
                ((Bot.Context)this.contexts().get(properties.username())).command("");
                return command.isEmpty() ? "" : "Exited from " + command + " " + String.join((CharSequence)" ", Arrays.asList(context.getObjects()));
            }
            return "";
        });
        this.add("where", Collections.emptyList(), Collections.emptyList(), "Shows the current directory", (properties, args) -> {
            Bot.Context context = (Bot.Context)this.contexts().get(properties.username());
            return context != null ? context : "root";
        });
        this.add("assets".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show the list of all units with its last status", (properties, args) -> this.cesarBotSlack.assets(properties));
        this.add("devices".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show the list of all devices with its last status", (properties, args) -> this.cesarBotSlack.devices(properties));
        this.add("devices-id".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show the list of all devices with its id", (properties, args) -> this.cesarBotSlack.devicesId(properties));
        this.add("projects".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show the list of all projects managed by Cesar", (properties, args) -> this.cesarBotSlack.projects(properties));
        this.add("servers".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "List of servers", (properties, args) -> this.cesarBotSlack.servers(properties));
        this.add("feeders".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "List of feeders", (properties, args) -> this.cesarBotSlack.feeders(properties));
        this.add("responsibles".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show registered responsibles", (properties, args) -> this.cesarBotSlack.responsibles(properties));
        this.add("develop-token".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Provides a token to develop systems on this infrastructure", (properties, args) -> this.cesarBotSlack.developToken(properties));
        this.add("notifications".toLowerCase(), "", Arrays.asList("state"), Arrays.asList(new String[0]), "Turn the notifications `on` `off`", (properties, args) -> this.cesarBotSlack.notifications(properties, args.length > 0 ? args[0] : ""));
        this.add("issues".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show the list of all compromised devices or servers", (properties, args) -> this.cesarBotSlack.issues(properties));
        this.add("manage".toLowerCase(), "", Arrays.asList(new String[0]), Arrays.asList("add-responsible", "remove-responsible", "add-devices", "add-device", "remove-device", "add-project", "remove-project", "add-server", "add-feeder", "remove-server", "remove-feeder"), "Administration cesar actions", (properties, args) -> this.cesarBotSlack.manage(properties));
        this.add("add-responsible".toLowerCase(), "manage", Arrays.asList("user", "email", "fullName"), Arrays.asList(new String[0]), "Register responsible in the infrastructure. Set `username`, `email` and `fullName`", (properties, args) -> this.manageSlack.addResponsible(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args));
        this.add("remove-responsible".toLowerCase(), "manage", Arrays.asList("user"), Arrays.asList(new String[0]), "Remove responsible by username. Will be removed also of all units", (properties, args) -> this.manageSlack.removeResponsible(properties, args.length > 0 ? args[0] : ""));
        this.add("add-devices".toLowerCase(), "manage", Arrays.asList("devices"), Arrays.asList(new String[0]), "Add a device list providing `deviceId` and `name` separated by `;`", (properties, args) -> this.manageSlack.addDevices(properties, args));
        this.add("add-device".toLowerCase(), "manage", Arrays.asList("deviceId", "name"), Arrays.asList(new String[0]), "Add a device providing `deviceId` and `name`", (properties, args) -> this.manageSlack.addDevice(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : ""));
        this.add("remove-device".toLowerCase(), "manage", Arrays.asList("device"), Arrays.asList(new String[0]), "Remove a device by either its `deviceId` or `name`", (properties, args) -> this.manageSlack.removeDevice(properties, args.length > 0 ? args[0] : ""));
        this.add("add-project".toLowerCase(), "manage", Arrays.asList("name"), Arrays.asList(new String[0]), "Add a project providing `name`", (properties, args) -> this.manageSlack.addProject(properties, args.length > 0 ? args[0] : ""));
        this.add("remove-project".toLowerCase(), "manage", Arrays.asList("name"), Arrays.asList(new String[0]), "Remove a device by either its `name`", (properties, args) -> this.manageSlack.removeProject(properties, args.length > 0 ? args[0] : ""));
        this.add("add-server".toLowerCase(), "manage", Arrays.asList("name", "url", "ip"), Arrays.asList(new String[0]), "Add a server providing `name` `url with port`, and `IP`", (properties, args) -> this.manageSlack.addServer(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args.length > 2 ? args[2] : ""));
        this.add("add-feeder".toLowerCase(), "manage", Arrays.asList("name", "url", "ip"), Arrays.asList(new String[0]), "Add a server providing `name` `url with port`, and `IP`", (properties, args) -> this.manageSlack.addFeeder(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args.length > 2 ? args[2] : ""));
        this.add("remove-server".toLowerCase(), "manage", Arrays.asList("name"), Arrays.asList(new String[0]), "Removes a server providing its `name`", (properties, args) -> this.manageSlack.removeServer(properties, args.length > 0 ? args[0] : ""));
        this.add("remove-feeder".toLowerCase(), "manage", Arrays.asList("name"), Arrays.asList(new String[0]), "Removes a feeder providing its `name`", (properties, args) -> this.manageSlack.removeFeeder(properties, args.length > 0 ? args[0] : ""));
        this.add("project".toLowerCase(), "", Arrays.asList("name"), Arrays.asList("systems", "remove-system", "add-device", "add-server", "add-feeder", "system"), "Project actions", (properties, args) -> this.cesarBotSlack.project(properties, args.length > 0 ? args[0] : ""));
        this.add("systems".toLowerCase(), "project", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "State of systems related with this project", (properties, args) -> this.projectSlack.systems(properties));
        this.add("remove-system".toLowerCase(), "project", Arrays.asList("name"), Arrays.asList(new String[0]), "Removes system `system-name`", (properties, args) -> this.projectSlack.removeSystem(properties, args.length > 0 ? args[0] : ""));
        this.add("add-device".toLowerCase(), "project", Arrays.asList("ids"), Arrays.asList(new String[0]), "Registers devices to this project", (properties, args) -> this.projectSlack.addDevice(properties, args));
        this.add("add-server".toLowerCase(), "project", Arrays.asList("name"), Arrays.asList(new String[0]), "Registers a server to this project", (properties, args) -> this.projectSlack.addServer(properties, args.length > 0 ? args[0] : ""));
        this.add("add-feeder".toLowerCase(), "project", Arrays.asList("name"), Arrays.asList(new String[0]), "Registers a feeder to this project", (properties, args) -> this.projectSlack.addFeeder(properties, args.length > 0 ? args[0] : ""));
        this.add("system".toLowerCase(), "project", Arrays.asList("systemId"), Arrays.asList("status", "log", "subscribe-log", "stop-log", "parameter", "start", "debug", "stop", "restart", "parameters", "ssh", "responsibles", "set-responsibles", "invoke", "operations"), "Open a connection with a syste by either its `deviceId`, `name` or `position` to operate with it", (properties, args) -> this.projectSlack.system(properties, args.length > 0 ? args[0] : ""));
        this.add("status".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Status of the selected system", (properties, args) -> this.projectSystemSlack.status(properties));
        this.add("log".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Log of system", (properties, args) -> this.projectSystemSlack.log(properties));
        this.add("subscribe-log".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Subscribe to Log of system", (properties, args) -> this.projectSystemSlack.subscribeLog(properties));
        this.add("stop-log".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Subscribe to Log of system", (properties, args) -> this.projectSystemSlack.stopLog(properties));
        this.add("parameter".toLowerCase(), "projectsystem", Arrays.asList("name", "value"), Arrays.asList(new String[0]), "Add or update value of a parameter", (properties, args) -> this.projectSystemSlack.parameter(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : ""));
        this.add("start".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Start system", (properties, args) -> this.projectSystemSlack.start(properties));
        this.add("debug".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Start system", (properties, args) -> this.projectSystemSlack.debug(properties));
        this.add("stop".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Stop system", (properties, args) -> this.projectSystemSlack.stop(properties));
        this.add("restart".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Restart system", (properties, args) -> this.projectSystemSlack.restart(properties));
        this.add("parameters".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Parameters of running system", (properties, args) -> this.projectSystemSlack.parameters(properties));
        this.add("ssh".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Ssh connection chain to the server its contained", (properties, args) -> this.projectSystemSlack.ssh(properties));
        this.add("responsibles".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show registered responsibles", (properties, args) -> this.projectSystemSlack.responsibles(properties));
        this.add("set-responsibles".toLowerCase(), "projectsystem", Arrays.asList("users"), Arrays.asList(new String[0]), "Assign responsibles to this system from registered", (properties, args) -> this.projectSystemSlack.setResponsibles(properties, args));
        this.add("invoke".toLowerCase(), "projectsystem", Arrays.asList("operation", "parameters"), Arrays.asList(new String[0]), "Invokes an available operation over this system", (properties, args) -> this.projectSystemSlack.invoke(properties, args.length > 0 ? args[0] : "", args));
        this.add("operations".toLowerCase(), "projectsystem", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Shows available operations of this system", (properties, args) -> this.projectSystemSlack.operations(properties));
        this.add("device".toLowerCase(), "", Arrays.asList("deviceId"), Arrays.asList("name", "status", "reboot", "grid", "screen", "tap", "tap-pixel", "drag", "kill", "launch", "uninstall", "install", "update", "execute", "responsibles", "set-responsibles", "set-notifications"), "Open a connection with a device by either its `deviceId`, `name` or `position`", (properties, args) -> this.cesarBotSlack.device(properties, args.length > 0 ? args[0] : ""));
        this.add("name".toLowerCase(), "device", Arrays.asList("newName"), Arrays.asList(new String[0]), "Rename the label of device-> name `newName`", (properties, args) -> this.deviceSlack.name(properties, args.length > 0 ? args[0] : ""));
        this.add("status".toLowerCase(), "device", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Status of the selected device", (properties, args) -> this.deviceSlack.status(properties));
        this.add("reboot".toLowerCase(), "device", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Reboots a device", (properties, args) -> this.deviceSlack.reboot(properties));
        this.add("grid".toLowerCase(), "device", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Shows what is on the device's screen including a guide to help the tap", (properties, args) -> this.deviceSlack.grid(properties));
        this.add("screen".toLowerCase(), "device", Arrays.asList("state"), Arrays.asList(new String[0]), "Shows what is on the device's screen or turns the device's screen `on` `off`", (properties, args) -> this.deviceSlack.screen(properties, args.length > 0 ? args[0] : ""));
        this.add("tap".toLowerCase(), "device", Arrays.asList("square"), Arrays.asList(new String[0]), "Produces a touch event in the given position of grid. Example: tap A5", (properties, args) -> this.deviceSlack.tap(properties, args.length > 0 ? args[0] : ""));
        this.add("tap-pixel".toLowerCase(), "device", Arrays.asList("x", "y"), Arrays.asList(new String[0]), "Produces a touch event in the given position X and Y", (properties, args) -> this.deviceSlack.tapPixel(properties, args.length > 0 ? Integer.parseInt(args[0]) : 0, args.length > 1 ? Integer.parseInt(args[1]) : 0));
        this.add("drag".toLowerCase(), "device", Arrays.asList("fromSquare", "toSquare"), Arrays.asList(new String[0]), "Produces a drag event from the origin square to destination", (properties, args) -> this.deviceSlack.drag(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : ""));
        this.add("kill".toLowerCase(), "device", Arrays.asList("packageName"), Arrays.asList(new String[0]), "Kill a task in the opened device by providing the `android package`", (properties, args) -> this.deviceSlack.kill(properties, args.length > 0 ? args[0] : ""));
        this.add("launch".toLowerCase(), "device", Arrays.asList("packageName"), Arrays.asList(new String[0]), "Launch a task in the opened device by providing the `android package`", (properties, args) -> this.deviceSlack.launch(properties, args.length > 0 ? args[0] : ""));
        this.add("uninstall".toLowerCase(), "device", Arrays.asList("packageName"), Arrays.asList(new String[0]), "Uninstall an apk in the opened device by providing the `android package`", (properties, args) -> this.deviceSlack.uninstall(properties, args.length > 0 ? args[0] : ""));
        this.add("install".toLowerCase(), "device", Arrays.asList("url"), Arrays.asList(new String[0]), "Install an apk in the opened device by providing the `url` to the file", (properties, args) -> this.deviceSlack.install(properties, args.length > 0 ? args[0] : ""));
        this.add("update".toLowerCase(), "device", Arrays.asList("url"), Arrays.asList(new String[0]), "Update an apk in the opened device by providing the `url` to the file", (properties, args) -> this.deviceSlack.update(properties, args.length > 0 ? args[0] : ""));
        this.add("execute".toLowerCase(), "device", Arrays.asList("command"), Arrays.asList(new String[0]), "Execute command on the device. Add name value pair after command name", (properties, args) -> this.deviceSlack.execute(properties, args));
        this.add("responsibles".toLowerCase(), "device", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show registered responsibles", (properties, args) -> this.deviceSlack.responsibles(properties));
        this.add("set-responsibles".toLowerCase(), "device", Arrays.asList("users"), Arrays.asList(new String[0]), "Assign responsibles to this device from registered", (properties, args) -> this.deviceSlack.setResponsibles(properties, args));
        this.add("set-notifications".toLowerCase(), "device", Arrays.asList("unplug", "temperature", "battery", "lowBattery", "disconnected"), Arrays.asList(new String[0]), "set notifications for `unplug` `temperature` `battery` `lowBattery` `disconnected` as macro on/off specifing all", (properties, args) -> this.deviceSlack.setNotifications(properties, args.length > 0 ? args[0] : "", args.length > 1 ? args[1] : "", args.length > 2 ? args[2] : "", args.length > 3 ? args[3] : "", args.length > 4 ? args[4] : ""));
        this.add("server".toLowerCase(), "", Arrays.asList("name"), Arrays.asList("name", "status", "remote-connection", "shutdown", "reboot", "log", "update-consul", "ssh", "responsibles", "set-responsibles"), "Open a connection with a server by either its `name` or `position`", (properties, args) -> this.cesarBotSlack.server(properties, args.length > 0 ? args[0] : ""));
        this.add("name".toLowerCase(), "server", Arrays.asList("newName"), Arrays.asList(new String[0]), "Rename the alias of device-> name `newName`", (properties, args) -> this.serverSlack.name(properties, args.length > 0 ? args[0] : ""));
        this.add("status".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Status of the selected server", (properties, args) -> this.serverSlack.status(properties));
        this.add("remote-connection".toLowerCase(), "server", Arrays.asList("url", "port", "user"), Arrays.asList(new String[0]), "set/get remote connection", (properties, args) -> this.serverSlack.remoteConnection(properties, args.length > 0 ? args[0] : "", args.length > 1 ? Integer.parseInt(args[1]) : 0, args.length > 2 ? args[2] : ""));
        this.add("shutdown".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Shutdown the server", (properties, args) -> this.serverSlack.shutdown(properties));
        this.add("reboot".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Reboot the server", (properties, args) -> this.serverSlack.reboot(properties));
        this.add("log".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Log of the server", (properties, args) -> this.serverSlack.log(properties));
        this.add("update-consul".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Update consul", (properties, args) -> this.serverSlack.updateConsul(properties));
        this.add("ssh".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Ssh connection chain to this server", (properties, args) -> this.serverSlack.ssh(properties));
        this.add("responsibles".toLowerCase(), "server", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show registered responsibles", (properties, args) -> this.serverSlack.responsibles(properties));
        this.add("set-responsibles".toLowerCase(), "server", Arrays.asList("users"), Arrays.asList(new String[0]), "Assign responsibles of this device from registered", (properties, args) -> this.serverSlack.setResponsibles(properties, args));
        this.add("feeder".toLowerCase(), "", Arrays.asList("name"), Arrays.asList("name", "status", "remote-connection", "shutdown", "reboot", "log", "update-consul", "responsibles", "set-responsibles"), "Open a connection with a feeder by either its `name` or `position`", (properties, args) -> this.cesarBotSlack.feeder(properties, args.length > 0 ? args[0] : ""));
        this.add("name".toLowerCase(), "feeder", Arrays.asList("newName"), Arrays.asList(new String[0]), "Rename the alias of device-> name `newName`", (properties, args) -> this.feederSlack.name(properties, args.length > 0 ? args[0] : ""));
        this.add("status".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Status of the selected feeder", (properties, args) -> this.feederSlack.status(properties));
        this.add("remote-connection".toLowerCase(), "feeder", Arrays.asList("url", "port", "user"), Arrays.asList(new String[0]), "set/get remote connection", (properties, args) -> this.feederSlack.remoteConnection(properties, args.length > 0 ? args[0] : "", args.length > 1 ? Integer.parseInt(args[1]) : 0, args.length > 2 ? args[2] : ""));
        this.add("shutdown".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Shutdown the feeder", (properties, args) -> this.feederSlack.shutdown(properties));
        this.add("reboot".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Reboot the feeder", (properties, args) -> this.feederSlack.reboot(properties));
        this.add("log".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Log of the feeder", (properties, args) -> this.feederSlack.log(properties));
        this.add("update-consul".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Update consul", (properties, args) -> this.feederSlack.updateConsul(properties));
        this.add("responsibles".toLowerCase(), "feeder", Arrays.asList(new String[0]), Arrays.asList(new String[0]), "Show registered responsibles", (properties, args) -> this.feederSlack.responsibles(properties));
        this.add("set-responsibles".toLowerCase(), "feeder", Arrays.asList("users"), Arrays.asList(new String[0]), "Assign responsibles of this device from registered", (properties, args) -> this.feederSlack.setResponsibles(properties, args));
        try {
            this.execute();
            this.cesarBotSlack.init(this.session());
            this.manageSlack.init(this.session());
            this.projectSlack.init(this.session());
            this.deviceSlack.init(this.session());
            this.serverSlack.init(this.session());
            this.feederSlack.init(this.session());
            this.projectSystemSlack.init(this.session());
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static String formatCommand(String command, Bot.CommandInfo info) {
        return "`" + command.substring(command.lastIndexOf("$") + 1) + CesarBotSlackBot.helpParameters(info.parameters()) + "` " + info.description() + "\n";
    }

    private static String helpParameters(List<String> parameters) {
        return parameters.isEmpty() ? "" : " <" + String.join((CharSequence)"> <", parameters) + ">";
    }
}

