/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.box;

import io.intino.cesar.box.CesarActivity;
import io.intino.cesar.box.CesarBotSlackBot;
import io.intino.cesar.box.CesarBox;
import io.intino.cesar.box.CesarConfiguration;
import io.intino.cesar.box.CesarRestResources;
import io.intino.cesar.box.Tasks;
import io.intino.cesar.box.ness.NessOperations;
import io.intino.cesar.box.ness.NessTanks;
import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.LogFormatter;
import io.intino.konos.alexandria.activity.ActivityAlexandriaSpark;
import io.intino.konos.alexandria.activity.ActivityBox;
import io.intino.konos.alexandria.activity.ActivityElementsActivity;
import io.intino.konos.alexandria.activity.displays.Soul;
import io.intino.konos.alexandria.activity.services.AuthService;
import io.intino.konos.alexandria.rest.AlexandriaSpark;
import io.intino.konos.datalake.Ness;
import io.intino.konos.scheduling.KonosTasker;
import io.intino.konos.slack.Bot;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
extends ActivityBox {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    protected CesarConfiguration configuration;
    private Bot cesarBot;
    private Ness ness;
    private KonosTasker tasker = new KonosTasker();
    protected Map<String, Soul> activitySouls = new HashMap<String, Soul>();
    private List<ActivityBox.SoulsClosed> soulsClosedListeners = new ArrayList<ActivityBox.SoulsClosed>();

    public AbstractBox(String[] args) {
        this(new CesarConfiguration(args));
    }

    public AbstractBox(CesarConfiguration configuration) {
        this.owner = new SumusBox((SumusConfiguration)configuration);
        this.configuration = configuration;
        this.initLogger();
        if (this.configuration().cesarRestConfiguration != null) {
            ActivityAlexandriaSpark.setup((int)this.configuration().cesarRestConfiguration.port, (String)this.configuration().cesarRestConfiguration.webDirectory, null);
        }
        if (this.configuration().cesarConfiguration != null) {
            ActivityAlexandriaSpark.setup((int)this.configuration().cesarConfiguration.port, (String)this.configuration().cesarConfiguration.webDirectory, (AuthService)this.configuration().cesarConfiguration.authService);
        }
    }

    public CesarConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        this.owner.put(o);
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initActivities();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        ActivityAlexandriaSpark.instance().stop();
        if (this.ness != null) {
            this.ness.stop();
        }
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.activitySouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.activitySouls.get(clientId));
    }

    public void registerSoul(String clientId, Soul soul) {
        if (this.owner != null) {
            ((SumusBox)this.owner).registerSoul(clientId, soul);
        }
        this.activitySouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        if (this.owner != null) {
            ((SumusBox)this.owner).unRegisterSoul(clientId);
        }
        this.activitySouls.remove(clientId);
        if (this.activitySouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(ActivityBox.SoulsClosed listener) {
        if (this.owner != null) {
            ((SumusBox)this.owner).onSoulsClosed(listener);
        }
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    public CesarBotSlackBot cesarBot() {
        return (CesarBotSlackBot)this.cesarBot;
    }

    public Ness datalake() {
        return this.ness;
    }

    public KonosTasker tasker() {
        return this.tasker;
    }

    private void initRESTServices() {
        if (this.configuration().cesarRestConfiguration == null) {
            return;
        }
        CesarRestResources.setup((AlexandriaSpark)ActivityAlexandriaSpark.instance(), (CesarBox)this).start();
        logger.info("REST service cesar-rest: started!");
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
        if (this.configuration().cesarBotConfiguration == null) {
            return;
        }
        this.cesarBot = new CesarBotSlackBot((CesarBox)this);
        logger.info("Slack service CesarBot: started!");
    }

    private void initActivities() {
        if (this.configuration().cesarConfiguration == null) {
            return;
        }
        ActivityAlexandriaSpark sparkInstance = ActivityAlexandriaSpark.instance();
        CesarActivity.init(sparkInstance, (CesarBox)this);
        ActivityElementsActivity.initDisplays((ActivityAlexandriaSpark)sparkInstance);
        sparkInstance.start();
        logger.info("Activity cesar: started!");
    }

    private void initDataLake() {
        if (this.configuration().nessConfiguration() == null) {
            return;
        }
        this.ness = new Ness(this.configuration().nessConfiguration().url, this.configuration().nessConfiguration().user, this.configuration().nessConfiguration().password, this.configuration().nessConfiguration().clientID);
        Thread thread = new Thread(() -> {
            this.ness.start();
            NessTanks.registerTanks((CesarBox)this);
            NessOperations.init((CesarBox)this);
            logger.info("Ness connection: started!");
        }, "ness init");
        try {
            thread.start();
            thread.join(10000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
    }

    private void initTasks() {
        Tasks.init(this.tasker, (CesarBox)this);
    }

    private void initLogger() {
        java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.addHandler(handler);
    }
}

