/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar;

import io.intino.cesar.graph.Asset;
import io.intino.cesar.graph.Device;
import io.intino.cesar.graph.DeviceDigest;
import io.intino.cesar.graph.DeviceStatus;
import io.intino.cesar.graph.System;
import io.intino.cesar.graph.SystemStatus;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.AbstractCategorization;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.tara.magritte.Layer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Sumus {
    public static List<String> statusCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        return Collections.singletonList(((Asset)item.core$().as(Asset.class)).isCompromised() ? "Compromised" : "OK");
    }

    public static List<String> screenCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        Device device = (Device)item.core$().as(Device.class);
        return Collections.singletonList(device.status() != null && device.isScreenOn() ? "On" : "Off");
    }

    public static List<String> batteryCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        Device device = (Device)item.core$().as(Device.class);
        return Collections.singletonList(device.status() != null && device.lowBattery() ? "Low" : "High");
    }

    public static List<String> pluggedCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        Device device = (Device)item.core$().as(Device.class);
        return Collections.singletonList(device.status() != null && device.isUnPlugged() ? "Off" : "On");
    }

    public static List<String> connectionCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        Device device = (Device)item.core$().as(Device.class);
        return Collections.singletonList(device.status() != null && device.isDisconnected() ? "Disconnected" : "Connected");
    }

    public static double screenDigest(MeasureIndicator.Formula self, List<Digest> digests) {
        return Sumus.ratio(digests, digests.stream().mapToDouble(s -> new DeviceDigest((Digest)s).isScreenOn()).sum()) * 100.0;
    }

    public static double batteryDigest(MeasureIndicator.Formula self, List<Digest> digests) {
        return Sumus.ratio(digests, digests.stream().mapToDouble(s -> new DeviceDigest((Digest)s).battery()).sum());
    }

    public static double temperatureDigest(MeasureIndicator.Formula self, List<Digest> digests) {
        return Sumus.ratio(digests, digests.stream().mapToDouble(s -> new DeviceDigest((Digest)s).temperature()).sum());
    }

    private static double ratio(List<Digest> digests, double sum) {
        int count = digests.stream().mapToInt(s -> new DeviceDigest((Digest)s).count()).sum();
        return count == 0 ? 0.0 : sum / (double)count;
    }

    public static List<String> unitCategorization(AbstractCategorization.RecordTagger self, Layer item) {
        return Collections.singletonList(item.core$().is(Device.class) ? "Device" : "Server");
    }

    public static List<String> allSystems(Categorization self) {
        return self.graph().core$().find(System.class).stream().map(s -> s.core$().id()).collect(Collectors.toList());
    }

    public static List<String> allDevices(Categorization self) {
        return self.graph().core$().find(Device.class).stream().map(s -> s.core$().id()).collect(Collectors.toList());
    }

    public static List<String> systemOfStatus(AbstractCategorization.RecordTagger self, Layer item) {
        System system = ((SystemStatus)item.a$(SystemStatus.class)).system();
        if (system == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(system.core$().id());
    }

    public static List<String> deviceOfStatus(AbstractCategorization.RecordTagger self, Layer item) {
        Device device = ((DeviceStatus)item.a$(DeviceStatus.class)).device();
        return device != null ? Collections.singletonList(device.core$().id()) : Collections.emptyList();
    }
}

