/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar;

import io.intino.cesar.graph.AbstractDevice;
import io.intino.cesar.graph.AbstractSystem;
import io.intino.cesar.graph.Consul;
import io.intino.cesar.graph.Server;
import io.intino.cesar.graph.ServerConsul;
import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;

public class Ontology {
    private static final int JMX_INITIAL_PORT = 10000;
    private static final int DEBUG_INITIAL_PORT = 6000;

    public static boolean fitsNewSystem(Consul consul, AbstractSystem.Deployment system) {
        return true;
    }

    public static boolean isAlive(ServerConsul self) {
        return !((Server)self.core$().ownerAs(Server.class)).isDisconnected();
    }

    public static int reserveDebugPort(Server self) {
        if (self.debugUsedPorts().isEmpty()) {
            self.debugUsedPorts().add(6000);
            return 6000;
        }
        int newPort = Ontology.unusedPort(self.debugUsedPorts(), 6000);
        self.debugUsedPorts().add(newPort);
        Collections.sort(self.debugUsedPorts());
        return newPort;
    }

    public static int reserveJMXPort(Server self) {
        if (self.jmxUsedPorts().isEmpty()) {
            self.jmxUsedPorts().add(10000);
            return 10000;
        }
        int newPort = Ontology.unusedPort(self.jmxUsedPorts(), 10000);
        self.jmxUsedPorts().add(newPort);
        Collections.sort(self.jmxUsedPorts());
        return newPort;
    }

    private static int unusedPort(List<Integer> used, Integer first) {
        int newPort = first;
        while (used.contains(newPort)) {
            ++newPort;
        }
        return newPort;
    }

    public static void releasePort(Server self, int port) {
        if (self.jmxUsedPorts().contains(port)) {
            self.jmxUsedPorts().remove((Object)port);
        }
        if (self.debugUsedPorts().contains(port)) {
            self.debugUsedPorts().remove((Object)port);
        }
    }

    public static void saveScreen(AbstractDevice.Screen self, byte[] image) {
        self.current(new ByteArrayInputStream(image), "infrastructure/devices/" + self.core$().owner().name() + "/screens/" + Instant.now().atOffset(ZoneOffset.UTC).getHour() + ".jpg");
    }
}

