package io.intino.cesar.box.schemas;

import io.intino.cesar.box.schemas.*;

public class ProcessDeployment implements java.io.Serializable {

	private String groupId;
	private String artifactId;
	private String version;
	private int jmxPort = 0;
	private String jvmOptions;
	private String destinationServer;
	private Prerequisites prerequisites;
	private Packaging packaging;
	private java.util.List<Artifactory> artifactoryList = new java.util.ArrayList<>();

	public String groupId() {
		return this.groupId;
	}

	public String artifactId() {
		return this.artifactId;
	}

	public String version() {
		return this.version;
	}

	public int jmxPort() {
		return this.jmxPort;
	}

	public String jvmOptions() {
		return this.jvmOptions;
	}

	public String destinationServer() {
		return this.destinationServer;
	}

	public Prerequisites prerequisites() {
		return this.prerequisites;
	}

	public Packaging packaging() {
		return this.packaging;
	}

	public java.util.List<Artifactory> artifactoryList() {
		return this.artifactoryList;
	}

	public ProcessDeployment groupId(String groupId) {
		this.groupId = groupId;
		return this;
	}

	public ProcessDeployment artifactId(String artifactId) {
		this.artifactId = artifactId;
		return this;
	}

	public ProcessDeployment version(String version) {
		this.version = version;
		return this;
	}

	public ProcessDeployment jmxPort(int jmxPort) {
		this.jmxPort = jmxPort;
		return this;
	}

	public ProcessDeployment jvmOptions(String jvmOptions) {
		this.jvmOptions = jvmOptions;
		return this;
	}

	public ProcessDeployment destinationServer(String destinationServer) {
		this.destinationServer = destinationServer;
		return this;
	}

	public ProcessDeployment prerequisites(Prerequisites prerequisites) {
		this.prerequisites = prerequisites;
		return this;
	}

	public ProcessDeployment packaging(Packaging packaging) {
		this.packaging = packaging;
		return this;
	}

	public ProcessDeployment artifactoryList(java.util.List<Artifactory> artifactoryList) {
		this.artifactoryList = artifactoryList;
		return this;
	}

	public static class Prerequisites implements java.io.Serializable {

		private int memory = 0;
		private double hdd = 2.0;

		public int memory() {
			return this.memory;
		}

		public double hdd() {
			return this.hdd;
		}

		public Prerequisites memory(int memory) {
			this.memory = memory;
			return this;
		}

		public Prerequisites hdd(double hdd) {
			this.hdd = hdd;
			return this;
		}
	}

	public static class Packaging implements java.io.Serializable {

		private String classpathPrefix;
		private String mainClass;
		private java.util.List<Parameter> parameterList = new java.util.ArrayList<>();

		public String classpathPrefix() {
			return this.classpathPrefix;
		}

		public String mainClass() {
			return this.mainClass;
		}

		public java.util.List<Parameter> parameterList() {
			return this.parameterList;
		}

		public Packaging classpathPrefix(String classpathPrefix) {
			this.classpathPrefix = classpathPrefix;
			return this;
		}

		public Packaging mainClass(String mainClass) {
			this.mainClass = mainClass;
			return this;
		}

		public Packaging parameterList(java.util.List<Parameter> parameterList) {
			this.parameterList = parameterList;
			return this;
		}

		public static class Parameter implements java.io.Serializable {

			private String name;
			private String value;

			public String name() {
				return this.name;
			}

			public String value() {
				return this.value;
			}

			public Parameter name(String name) {
				this.name = name;
				return this;
			}

			public Parameter value(String value) {
				this.value = value;
				return this;
			}
		}
	}

	public static class Artifactory implements java.io.Serializable {

		private String id;
		private String url;
		private String user;
		private String password;

		public String id() {
			return this.id;
		}

		public String url() {
			return this.url;
		}

		public String user() {
			return this.user;
		}

		public String password() {
			return this.password;
		}

		public Artifactory id(String id) {
			this.id = id;
			return this;
		}

		public Artifactory url(String url) {
			this.url = url;
			return this;
		}

		public Artifactory user(String user) {
			this.user = user;
			return this;
		}

		public Artifactory password(String password) {
			this.password = password;
			return this;
		}
	}
}