/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import io.intino.cesar.schemas.DeviceStatus;
import io.intino.cesar.schemas.ProjectSchema;
import io.intino.cesar.schemas.ServerSchema;
import io.intino.cesar.schemas.ServerStatus;
import io.intino.cesar.schemas.SystemSchema;
import io.intino.konos.alexandria.exceptions.BadRequest;
import io.intino.konos.alexandria.exceptions.Forbidden;
import io.intino.konos.alexandria.exceptions.Unknown;
import io.intino.konos.restful.core.RestfulAccessor;
import io.intino.konos.restful.exceptions.RestfulFailure;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CesarRestAccessor {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private URL url;
    private static Gson gsonReader = CesarRestAccessor.gsonReader();
    private static Gson gsonWriter = CesarRestAccessor.gsonWriter();
    private RestfulAccessor accessor = new RestfulAccessor();

    public CesarRestAccessor(URL url) {
        this.url = url;
    }

    public List<ProjectSchema> getProjects() throws BadRequest, Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.get(this.url, "/projects").content(), new TypeToken<List<ProjectSchema>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<SystemSchema> getSystems(String project) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (List)gsonReader.fromJson(this.accessor.get(this.url, "/" + project + "/systems").content(), new TypeToken<List<SystemSchema>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public SystemSchema getSystem(String project, String system) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (SystemSchema)gsonReader.fromJson(this.accessor.get(this.url, "/" + project + "/systems/" + system).content(), SystemSchema.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<ServerSchema> getServers() throws BadRequest, Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.get(this.url, "/servers").content(), new TypeToken<List<ServerSchema>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ServerSchema getServer(String server) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerSchema)gsonReader.fromJson(this.accessor.get(this.url, "/servers/" + server).content(), ServerSchema.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<String> getDevices() throws BadRequest, Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.get(this.url, "/devices").content(), new TypeToken<ArrayList<String>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public List<ServerSchema> getFeeders() throws BadRequest, Unknown {
        try {
            return (List)gsonReader.fromJson(this.accessor.get(this.url, "/devices").content(), new TypeToken<List<ServerSchema>>(){}.getType());
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public DeviceStatus getDevice(String device) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (DeviceStatus)gsonReader.fromJson(this.accessor.get(this.url, "/devices/" + device).content(), DeviceStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ServerSchema getFeeder(String feeder) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerSchema)gsonReader.fromJson(this.accessor.get(this.url, "/feeders/" + feeder).content(), ServerSchema.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public ServerStatus getFeederStatus(String feeder) throws BadRequest, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){};
            return (ServerStatus)gsonReader.fromJson(this.accessor.get(this.url, "/feeders/" + feeder + "/status").content(), ServerStatus.class);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    public void postDeployProcess(final String user, final SystemSchema process) throws BadRequest, Forbidden, Unknown {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>(){
                {
                    if (user != null) {
                        this.put("user", user);
                    }
                    if (process != null) {
                        this.put("process", CesarRestAccessor.this.encode(String.valueOf(gsonWriter.toJson((Object)process))));
                    }
                }
            };
            this.accessor.post(this.url, "/deploy", (Map)parameters);
        }
        catch (RestfulFailure e) {
            if (e.code().equals("400")) {
                throw new BadRequest(e.label());
            }
            if (e.code().equals("403")) {
                throw new Forbidden(e.label());
            }
            throw new Unknown(e.label());
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static Gson gsonReader() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (json, type1, jsonDeserializationContext) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, jsonDeserializationContext) -> new Date(json.getAsJsonPrimitive().getAsLong())).create();
    }

    private static Gson gsonWriter() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (instant, type, context) -> new JsonPrimitive((Number)instant.toEpochMilli())).registerTypeAdapter(Date.class, (date, type, context) -> new JsonPrimitive((Number)date.getTime())).create();
    }
}

