/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.runner;

import java.io.File;
import java.io.IOException;
import java.util.function.Function;

public record ProjectDirectory(File root) {
    public static final String PROJECT_BIND = "/project";

    public ProjectDirectory(File root) {
        try {
            this.root = root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProjectDirectory of(File root, String name) {
        return new ProjectDirectory(new File(root, name));
    }

    public Function<String, String> directoryMapper() {
        return f -> f.replace(this.root.getAbsolutePath(), PROJECT_BIND);
    }

    public Function<String, String> reverseDirectoryMapper() {
        return f -> {
            try {
                return new File(f.replace(PROJECT_BIND, this.root.getAbsolutePath())).getCanonicalPath();
            }
            catch (IOException e) {
                return f;
            }
        };
    }

    public boolean exists() {
        return this.root.exists();
    }

    public File argsFile() {
        return new File(this.root, "tara_args.txt").getAbsoluteFile();
    }

    public File logFile() {
        return new File(this.root, "output.log").getAbsoluteFile();
    }

    public File res() {
        return new File(this.root.getAbsolutePath(), "res");
    }

    public File src() {
        return new File(this.root.getAbsolutePath(), "src");
    }

    public File out() {
        return new File(this.root.getAbsolutePath(), "out" + File.separator + "production");
    }

    public File build() {
        return new File(this.root.getAbsolutePath(), "out" + File.separator + "build");
    }

    public File gen() {
        return new File(this.root.getAbsolutePath(), "gen");
    }
}

