/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.runner;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.konos.schemas.BuilderInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ContainerManager {
    private final Properties properties;
    private final Map<String, String> containerIds = new HashMap<String, String>();
    private final String url;
    private final String hostUser;

    public ContainerManager(String url, File hubAuth) {
        this.url = url;
        this.properties = new Properties();
        this.load(hubAuth);
        this.hostUser = this.hostUser();
    }

    public void download(String imageURL) throws InterruptedException, IOException {
        try (DockerClient dockerClient = this.dockerClient();){
            ((PullImageResultCallback)dockerClient.pullImageCmd(imageURL).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
        }
    }

    public void download(String imageURL, String registryToken) throws InterruptedException, IOException {
        try (DockerClient dockerClient = this.dockerClient();){
            if (registryToken != null) {
                dockerClient.authConfig().withRegistrytoken(registryToken);
            }
            ((PullImageResultCallback)dockerClient.pullImageCmd(imageURL).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
        }
    }

    public BuilderInfo builderInfo(String imageURL) throws Conflict, IOException {
        try (DockerClient dockerClient = this.dockerClient();){
            InspectImageResponse imageInfo = dockerClient.inspectImageCmd(imageURL).exec();
            BuilderInfo builderInfo = new BuilderInfo();
            if (imageInfo.getConfig() == null || imageInfo.getConfig().getLabels() == null) {
                throw new Conflict("Configuration not found");
            }
            Map labels = imageInfo.getConfig().getLabels();
            if (!labels.containsKey("targets")) {
                throw new Conflict("No target label found");
            }
            if (!labels.containsKey("operations")) {
                throw new Conflict("No operations label found");
            }
            String[] targets = ((String)labels.get("targets")).split(",");
            String[] operations = ((String)labels.get("operations")).split(",");
            labels.remove("targets");
            labels.remove("operations");
            BuilderInfo builderInfo2 = builderInfo.imageURL(imageURL).creationDate(imageInfo.getCreated()).targetLanguages(List.of(targets)).operations(List.of(operations)).properties(labels);
            return builderInfo2;
        }
    }

    private DockerClient dockerClient() {
        DockerClient client = this.url != null ? DockerClientBuilder.getInstance((String)this.url).build() : DockerClientBuilder.getInstance().build();
        client.authConfig().withUsername(this.properties.getProperty("user")).withRegistrytoken("password");
        return client;
    }

    public String createContainer(String imageName, String containerName, Bind ... bind) throws IOException {
        String string;
        block8: {
            DockerClient client = this.dockerClient();
            try {
                CreateContainerResponse container = client.createContainerCmd(imageName).withName(containerName).withUser(this.hostUser).withHostConfig(HostConfig.newHostConfig().withBinds(bind).withAutoRemove(Boolean.valueOf(true))).exec();
                this.containerIds.put(containerName, container.getId());
                string = container.getId();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage() + ". Is docker started?");
                }
            }
            client.close();
        }
        return string;
    }

    public void start(String container) {
        try (DockerClient client = this.dockerClient();){
            client.startContainerCmd(container).exec();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isRunning(String ticket) {
        String containerId = this.containerIds.get(ticket);
        if (containerId == null) {
            return false;
        }
        try (DockerClient client = this.dockerClient();){
            if (((List)client.listContainersCmd().exec()).stream().noneMatch(c -> c.getId().equalsIgnoreCase(containerId))) {
                Boolean bl2 = false;
                return bl2;
            }
            InspectContainerResponse containerInfo = client.inspectContainerCmd(containerId).exec();
            Boolean bl = containerInfo.getState().getRunning();
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void load(File hubAuth) {
        try {
            this.properties.load(new FileInputStream(hubAuth));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String hostUser() {
        try {
            Process uidProcess = new ProcessBuilder("id", "-u").start();
            Process gidProcess = new ProcessBuilder("id", "-g").start();
            BufferedReader uidReader = new BufferedReader(new InputStreamReader(uidProcess.getInputStream()));
            BufferedReader gidReader = new BufferedReader(new InputStreamReader(gidProcess.getInputStream()));
            return uidReader.readLine().trim() + ":" + gidReader.readLine().trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

