/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.actions;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.runner.BuilderRunner;
import io.intino.builderservice.konos.schemas.RunOperationContext;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PostRunOperationAction
implements RequestErrorHandler {
    public BuilderServiceBox box;
    public AlexandriaHttpContext context;
    public RunOperationContext runOperationContext;
    public Resource filesInTar;

    public String execute() throws InternalServerError {
        try {
            if (!new File(this.runOperationContext.languagePath()).exists()) {
                throw new BadRequest("Language path does not exist");
            }
            if (this.box.builderStore().get(this.runOperationContext.imageURL()) == null) {
                throw new NotFound("Builder not found");
            }
            if (this.filesInTar == null) {
                throw new BadRequest("Required source files");
            }
            this.copyLanguageToRepository();
            AbstractMap.SimpleEntry<String, List<File>> ticketWithSources = new BuilderRunner(this.box.builderStore(), this.box.containerManager(), this.box.workspace(), new File(this.box.configuration().languageRepository())).run(this.runOperationContext, this.filesInTar.inputStream());
            this.box.registerOperationHandler(ticketWithSources.getKey(), ticketWithSources.getValue());
            return ticketWithSources.getKey();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            throw new InternalServerError(e.getMessage());
        }
    }

    private void copyLanguageToRepository() throws BadRequest, IOException {
        File repo = new File(this.box.configuration().languageRepository());
        File source = new File(this.runOperationContext.languagePath());
        if (!source.exists()) {
            throw new BadRequest("Language file does not exist");
        }
        repo.mkdirs();
        File destination = new File(repo, String.join((CharSequence)File.separator, this.runOperationContext.languageGroup().replace(".", File.separator), this.runOperationContext.languageName(), this.runOperationContext.languageVersion(), this.runOperationContext.languageName() + "-" + this.runOperationContext.languageVersion() + ".jar"));
        destination.getParentFile().mkdirs();
        if (!source.equals(destination)) {
            FileUtils.copyFile((File)source, (File)destination);
        }
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }
}

