/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.actions;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.intino.builder.CompilerMessage;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.runner.OperationOutputHandler;
import io.intino.builderservice.konos.runner.ProjectDirectory;
import io.intino.builderservice.konos.schemas.Message;
import io.intino.builderservice.konos.schemas.OperationResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class GetOperationOutputAction
implements RequestErrorHandler {
    public BuilderServiceBox box;
    public AlexandriaHttpContext context;
    public String ticket;

    public OperationResult execute() throws NotFound {
        ProjectDirectory directory = ProjectDirectory.of(this.box.workspace(), this.ticket);
        if (!directory.exists()) {
            throw new NotFound("Ticket does not exist");
        }
        OperationOutputHandler handler = this.box.operationHandler(this.ticket);
        handler.readOutput();
        OperationResult result = new OperationResult();
        if (this.emptyIfNull(directory.gen().listFiles()).length > 0) {
            result.genRef(directory.gen().getName());
        }
        if (this.srcFiles(directory, handler).length > 0) {
            result.srcRef(directory.src().getName());
        }
        if (this.emptyIfNull(directory.res().listFiles()).length > 0) {
            result.resRef(directory.res().getName());
        }
        if (this.emptyIfNull(directory.out().listFiles()).length > 0) {
            result.outRef(directory.out().getName());
        }
        if (this.emptyIfNull(directory.build().listFiles()).length > 0) {
            result.buildRef(directory.build().getName());
        }
        result.messages(this.map(handler.compilerMessages(), directory));
        result.success(result.messages().stream().noneMatch(m -> m.kind().equals((Object)Message.Kind.ERROR)));
        result.state(this.box.containerManager().isRunning(this.ticket) != false ? OperationResult.State.Running : OperationResult.State.Finished);
        return result;
    }

    private File[] srcFiles(ProjectDirectory directory, OperationOutputHandler handler) {
        return this.excludeSourceFiles(directory.src(), handler.srcFiles());
    }

    private List<Message> map(List<CompilerMessage> compilerMessages, ProjectDirectory directory) {
        return new ArrayList<CompilerMessage>(compilerMessages).stream().map(c -> this.messageOf(directory, (CompilerMessage)c)).toList();
    }

    private Message messageOf(ProjectDirectory directory, CompilerMessage c) {
        return new Message().kind(this.kindOf(c.category())).column(c.columnNum()).content(c.message()).line(c.lineNum()).uri(c.url().replace(GetOperationOutputAction.canonicalPath(directory), ""));
    }

    private File[] excludeSourceFiles(File srcDirectory, final List<File> srcFiles) {
        return FileUtils.listFiles((File)srcDirectory, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return !srcFiles.contains(file);
            }

            public boolean accept(File dir, String name) {
                return true;
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE).toArray(new File[0]);
    }

    private Message.Kind kindOf(String category) {
        if (category.equalsIgnoreCase(Message.Kind.ERROR.name())) {
            return Message.Kind.ERROR;
        }
        if (category.equalsIgnoreCase(Message.Kind.WARNING.name())) {
            return Message.Kind.WARNING;
        }
        return Message.Kind.INFO;
    }

    private File[] emptyIfNull(File[] files) {
        return files == null ? new File[]{} : files;
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }

    private static String canonicalPath(ProjectDirectory directory) {
        try {
            return directory.src().getCanonicalPath() + File.separator;
        }
        catch (IOException e) {
            return "";
        }
    }
}

