/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.actions;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.http.server.AlexandriaHttpContext;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.rest.RequestErrorHandler;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.schemas.BuilderInfo;
import java.io.IOException;
import java.util.Optional;

public class GetBuilderInfoAction
implements RequestErrorHandler {
    public String registryToken;
    public BuilderServiceBox box;
    public AlexandriaHttpContext context;
    public String imageURL;

    public BuilderInfo execute() throws Conflict, NotFound {
        Optional<BuilderInfo> info = this.box.builderStore().all().stream().filter(b -> b.imageURL().equalsIgnoreCase(this.imageURL)).findFirst();
        return info.isPresent() ? info.get() : this.findBuilder();
    }

    private BuilderInfo findBuilder() throws Conflict, NotFound {
        try {
            this.box.containerManager().download(this.imageURL, this.registryToken);
            return this.box.containerManager().builderInfo(this.imageURL);
        }
        catch (IOException | InterruptedException e) {
            Logger.error((Throwable)e);
            throw new NotFound(e.getMessage());
        }
    }

    public void onMalformedRequest(Throwable e) throws AlexandriaException {
        throw new BadRequest("Malformed request");
    }
}

