/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos;

import io.intino.alexandria.http.AlexandriaHttpServer;
import io.intino.alexandria.http.AlexandriaHttpServerBuilder;
import io.intino.alexandria.http.pushservice.AlexandriaPushService;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.builderservice.konos.BuilderServiceBox;
import io.intino.builderservice.konos.rest.notifications.SubscribeOperationNotification;
import io.intino.builderservice.konos.rest.resources.GetBuilderInfoResource;
import io.intino.builderservice.konos.rest.resources.GetBuildersResource;
import io.intino.builderservice.konos.rest.resources.GetOperationOutputResource;
import io.intino.builderservice.konos.rest.resources.GetOutputResourceResource;
import io.intino.builderservice.konos.rest.resources.PostBuildersResource;
import io.intino.builderservice.konos.rest.resources.PostRunOperationResource;

public class BuilderServiceService {
    public static AlexandriaHttpServer setup(AlexandriaHttpServer server, BuilderServiceBox box) {
        if (!AlexandriaHttpServerBuilder.isUI()) {
            server.route("/_alexandria/push").push((PushService)new AlexandriaPushService());
        }
        server.route("operation/:ticket/messages").post(manager -> new SubscribeOperationNotification(box, manager).execute());
        server.route("api/builders").get(manager -> new GetBuildersResource(box, manager).execute());
        server.route("api/builders").post(manager -> new PostBuildersResource(box, manager).execute());
        server.route("api/builders/info").get(manager -> new GetBuilderInfoResource(box, manager).execute());
        server.route("api/operations/run").post(manager -> new PostRunOperationResource(box, manager).execute());
        server.route("api/operation/:ticket/output").get(manager -> new GetOperationOutputResource(box, manager).execute());
        server.route("api/operation/:ticket/outputs/:output").get(manager -> new GetOutputResourceResource(box, manager).execute());
        return server;
    }
}

