/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.builderservice.konos.AbstractBox;
import io.intino.builderservice.konos.BuilderServiceConfiguration;
import io.intino.builderservice.konos.BuilderStore;
import io.intino.builderservice.konos.runner.ContainerManager;
import io.intino.builderservice.konos.runner.OperationOutputHandler;
import io.intino.builderservice.konos.runner.ProjectDirectory;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuilderServiceBox
extends AbstractBox {
    private final BuilderStore builderStore;
    private final ContainerManager containerManager;
    private final File workspace;
    private final Map<String, OperationOutputHandler> operationHandlers;

    public BuilderServiceBox(String[] args) {
        this(new BuilderServiceConfiguration(args));
    }

    public BuilderServiceBox(BuilderServiceConfiguration configuration) {
        super(configuration);
        this.containerManager = new ContainerManager(configuration.dockerUrl(), this.configuration().dockerhubAuthFile());
        this.builderStore = new BuilderStore(this.containerManager, new File(configuration.home(), "builder-service/store"));
        this.workspace = new File(configuration.home(), "builder-service/workspace");
        this.operationHandlers = new HashMap<String, OperationOutputHandler>();
        this.workspace.mkdirs();
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        return this;
    }

    public BuilderStore builderStore() {
        return this.builderStore;
    }

    public File workspace() {
        return this.workspace;
    }

    public ContainerManager containerManager() {
        return this.containerManager;
    }

    public void registerOperationHandler(String ticket, List<File> srcFiles) {
        if (this.operationHandlers.containsKey(ticket)) {
            Logger.error((String)("Ticket " + ticket + " already registered"));
        } else {
            ProjectDirectory projectDirectory = ProjectDirectory.of(this.workspace(), ticket);
            this.operationHandlers.put(ticket, new OperationOutputHandler(projectDirectory, srcFiles));
        }
    }

    public OperationOutputHandler operationHandler(String ticket) {
        return this.operationHandlers.get(ticket);
    }

    @Override
    public void beforeStart() {
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }
}

