/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice.konos.runner;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.directory.DirectorySentinel;
import io.intino.builder.CompilerMessage;
import io.intino.builder.OutputItem;
import io.intino.builderservice.konos.runner.ProjectDirectory;
import io.intino.builderservice.konos.schemas.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OperationOutputHandler {
    private static final String COMPILER_IN_OPERATION = "Compiler in operation...";
    private final List<OutputItem> compiledItems = new ArrayList<OutputItem>();
    private final List<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
    private final List<File> srcFiles;
    private final ProjectDirectory project;
    private Consumer<String> statusUpdater;

    public OperationOutputHandler(ProjectDirectory project, List<File> srcFiles) {
        this.project = project;
        this.srcFiles = srcFiles;
    }

    public OperationOutputHandler statusUpdater(Consumer<String> statusUpdater) {
        this.statusUpdater = statusUpdater;
        return this;
    }

    public List<OutputItem> compiledItems() {
        return this.compiledItems;
    }

    public List<File> srcFiles() {
        return this.srcFiles;
    }

    public List<CompilerMessage> compilerMessages() {
        return this.compilerMessages;
    }

    public void readOutput() {
        try {
            this.compiledItems.clear();
            this.compilerMessages.clear();
            if (this.project.logFile().exists()) {
                this.readLog(Files.readString(this.project.logFile().toPath()));
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void readLog(String text) {
        String trimmed = text.trim();
        if (!trimmed.isEmpty()) {
            for (String line : trimmed.split("\n")) {
                if (line.startsWith("@#$%@# Presentable:")) {
                    this.updateStatus(line.substring("@#$%@# Presentable:".length()));
                    continue;
                }
                if ("$@#$%^ CLEAR_PRESENTABLE".equals(line)) {
                    this.updateStatus(null);
                    continue;
                }
                if (line.startsWith("%%m")) {
                    this.processMessage(this.clean(line, "%%m", "/%m"));
                }
                if (!line.startsWith("%%c")) continue;
                this.processCompiledItem(this.clean(line, "%%c", "/%c"));
            }
        }
    }

    private void processCompiledItem(String line) {
        List<String> list = this.splitAndTrim(line);
        this.compiledItems.add(new OutputItem(this.project.reverseDirectoryMapper().apply(list.get(0)), this.project.reverseDirectoryMapper().apply(list.get(1))));
    }

    private void processMessage(String text) {
        List<String> tokens = this.splitAndTrim(text);
        String category = tokens.get(0);
        String message = tokens.get(1);
        String url = this.project.reverseDirectoryMapper().apply(tokens.get(2));
        String lineNum = tokens.get(3);
        String columnNum = tokens.get(4);
        int line = 0;
        int column = 0;
        try {
            line = Integer.parseInt(lineNum);
            column = Integer.parseInt(columnNum);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Message.Kind kind = category.equals("error") ? Message.Kind.ERROR : (category.equals("warning") ? Message.Kind.WARNING : Message.Kind.INFO);
        this.compilerMessages.add(new CompilerMessage(kind.name(), message, url, line, column));
    }

    private String clean(String line, String messagesStart, String messagesEnd) {
        return line.replaceFirst("%%m", "").replace("/%m", "");
    }

    private void updateStatus(String status) {
        if (this.statusUpdater != null) {
            this.statusUpdater.accept(status == null ? COMPILER_IN_OPERATION : status);
        }
    }

    private List<String> splitAndTrim(String compiled) {
        return OperationOutputHandler.map(List.of(compiled.split("#%%#%%%#%%%%%%%%%#")), String::trim);
    }

    public static <T, V> List<V> map(Collection<? extends T> collection, Function<? super T, ? extends V> mapping) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return collection.stream().map(mapping::apply).collect(Collectors.toCollection(() -> new ArrayList(collection.size())));
    }

    private static class Sentinel {
        private final File file;
        private DirectorySentinel sentinel;

        private Sentinel(File file) {
            this.file = file;
        }

        public void init(Consumer<String> consumer) {
            try {
                File directory = this.file.getParentFile();
                if (!directory.exists()) {
                    Logger.warn((String)("Directory to listen" + directory.getAbsolutePath() + " not found"));
                } else {
                    AtomicInteger bytesRead = new AtomicInteger();
                    this.sentinel = new DirectorySentinel(directory, (f, event) -> {
                        if (f.equals(this.file) && event.equals((Object)DirectorySentinel.Event.OnCreate) || event.equals((Object)DirectorySentinel.Event.OnModify)) {
                            bytesRead.set(Sentinel.notifyChanges(this.file, bytesRead, consumer));
                        }
                    }, new DirectorySentinel.Event[]{DirectorySentinel.Event.OnModify});
                    this.sentinel.watch();
                }
            }
            catch (Exception e) {
                Logger.error((String)e.getMessage());
            }
        }

        private static int notifyChanges(File file, AtomicInteger bytesRead, Consumer<String> consumer) {
            try {
                byte[] bytes = Files.readAllBytes(file.toPath());
                int from = bytesRead.get();
                if (from >= bytes.length) {
                    return from;
                }
                byte[] newBytes = Arrays.copyOfRange(bytes, from, bytes.length);
                consumer.accept(new String(newBytes));
                return bytes.length;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return 0;
            }
        }

        public void stop() {
            this.sentinel.stop();
        }
    }
}

