/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.shared;

public class Property {
    public static final String Identifier = "id/";
    public static final String Feature = "feature/";
    public static final String Credential = "credential/";
    public static final String Role = "role/";
    private final String name;
    private final Type type;
    private final Cardinality cardinality;
    private final String grammar;

    public Property(String name, Type type) {
        this(name, type, null);
    }

    public Property(String name, Type type, String grammar) {
        this(name, type, grammar, Cardinality.single);
    }

    public Property(String name, Type type, String grammar, Cardinality cardinality) {
        this.name = name;
        this.type = type;
        this.grammar = grammar;
        this.cardinality = cardinality;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    boolean isIdentifier() {
        return this.name.startsWith(Identifier);
    }

    public String grammar() {
        return this.grammar;
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public static enum Cardinality {
        single,
        multiple;

    }

    public static enum Type {
        string,
        image;

    }
}

