/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.rocketchat;

import com.github.baloise.rocketchatrestclient.RocketChatClient;
import com.github.baloise.rocketchatrestclient.model.Message;
import com.github.baloise.rocketchatrestclient.model.Room;
import com.github.baloise.rocketchatrestclient.model.User;
import io.intino.alexandria.http.AlexandriaSpark;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.connectors.rocketchat.ProxyBot;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.connectors.MessagingConnector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class RocketChatConnector
implements MessagingConnector {
    private final RocketChatClient chatClient;
    private final List<User> users;
    private final ProxyBot proxyBot;

    public RocketChatConnector(Properties configuration) {
        this.chatClient = new RocketChatClient(RocketChatConnector.getEndPointFromDomainName(configuration.getProperty("federation.connectors.rocketChat.url")), configuration.getProperty("federation.connectors.rocketChat.bot.user"), configuration.getProperty("federation.connectors.rocketChat.bot.password"));
        this.proxyBot = new ProxyBot(configuration, this.chatClient);
        this.users = new ArrayList<User>();
        this.loadUsers();
    }

    public boolean sendMessage(String userName, String message) {
        User user;
        if (this.users.isEmpty()) {
            this.loadUsers();
        }
        if ((user = this.findUserByName(userName)) == null) {
            return false;
        }
        this.sendToUser(user, message);
        return true;
    }

    public boolean sendMessage(String team, String channel, String message) {
        User user;
        if (this.users.isEmpty()) {
            this.loadUsers();
        }
        if ((user = this.findUserByName(channel)) == null) {
            return false;
        }
        this.sendToUser(user, message);
        return true;
    }

    public void setup(AlexandriaSpark alexandriaSpark) {
    }

    public void start(Team team) {
        this.proxyBot.start();
    }

    private void sendToUser(User user, String message) {
        Room room = this.roomOf(user);
        try {
            this.chatClient.getChatApi().postMessage(room, new Message(message));
        }
        catch (IOException e) {
            Logger.error((String)(e.getMessage() + ":" + room.getRoomId() + " -> " + message));
        }
    }

    public User findUserByName(String aUser) {
        String user = aUser.startsWith("@") ? aUser.substring(1) : aUser;
        return this.users.stream().filter(u -> u.getUsername().equals(user)).findFirst().orElse(null);
    }

    private void loadUsers() {
        try {
            this.chatClient.getChannelsApi().list();
            Collections.addAll(this.users, this.chatClient.getUsersApi().list());
        }
        catch (Throwable e) {
            Logger.error((String)e.getMessage());
        }
    }

    private Room roomOf(User user) {
        Room room = new Room(user.getUsername(), true);
        room.setId("@" + user.getUsername());
        return room;
    }

    private static String getEndPointFromDomainName(String domainName) {
        return domainName.startsWith("ws") ? domainName.replaceFirst("ws", "http") : domainName;
    }
}

