/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.rocketchat;

import com.github.baloise.rocketchatrestclient.RocketChatClient;
import com.github.baloise.rocketchatrestclient.model.User;
import com.rocketchat.common.data.model.ErrorObject;
import com.rocketchat.common.data.model.Room;
import com.rocketchat.common.data.model.UserObject;
import com.rocketchat.common.listener.ConnectListener;
import com.rocketchat.common.listener.SubscribeListener;
import com.rocketchat.common.network.ReconnectionStrategy;
import com.rocketchat.core.RocketChatAPI;
import com.rocketchat.core.callback.FileListener;
import com.rocketchat.core.callback.LoginListener;
import com.rocketchat.core.factory.ChatRoomFactory;
import com.rocketchat.core.model.FileObject;
import com.rocketchat.core.model.RocketChatMessage;
import com.rocketchat.core.model.TokenObject;
import io.intino.alexandria.Base64;
import io.intino.alexandria.Json;
import io.intino.alexandria.cli.schemas.BotResponse;
import io.intino.alexandria.cli.schemas.BotTalk;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.restaccessor.core.RestAccessor;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ProxyBot
implements ConnectListener,
LoginListener {
    private final Properties configuration;
    private final RocketChatClient chatClient;
    private final Set<String> subscribedRooms = new HashSet<String>();
    private final Map<String, String> userTimeZones;
    private RocketChatAPI client;
    private String userId;

    public ProxyBot(Properties configuration, RocketChatClient chatClient) {
        this.configuration = configuration;
        this.chatClient = chatClient;
        this.userTimeZones = new HashMap<String, String>();
    }

    public void start() {
        this.client = new RocketChatAPI(this.configuration.getProperty("federation.connectors.rocketChat.url"));
        this.client.setReconnectionStrategy(new ReconnectionStrategy(20, 2000));
        this.client.connect((ConnectListener)this);
    }

    public void onConnect(String sessionID) {
        this.client.login(this.configuration.getProperty("federation.connectors.rocketChat.bot.user"), this.configuration.getProperty("federation.connectors.rocketChat.bot.password"), (LoginListener)this);
        this.client.setStatus(UserObject.Status.ONLINE, (aBoolean, errorObject) -> System.out.println(errorObject.getError()));
    }

    public void onLogin(TokenObject token, ErrorObject error) {
        Logger.info((String)(error == null ? this.configuration.getProperty("federation.connectors.rocketChat.bot.user") + " connected successfully to Rocket.Chat" : "Got error " + error.getMessage()));
        this.userId = token.getUserId();
        this.reloadSubscriptions();
    }

    private void reloadSubscriptions() {
        this.client.getRooms((rooms, e) -> {
            ChatRoomFactory factory = this.client.getChatRoomFactory();
            rooms.stream().map(ChatRoom::new).filter(r -> !this.isPublic((ChatRoom)((Object)((Object)r)))).forEach(arg_0 -> ((ChatRoomFactory)factory).addChatRoom(arg_0));
            factory.getChatRooms().forEach(r -> {
                if (!this.subscribedRooms.add(r.getRoomData().getRoomId())) {
                    return;
                }
                r.subscribeRoomMessageEvent(this.emptySubscriber(), (roomId, message) -> new Thread(() -> {
                    if (message.getSender().getUserId().equals(this.userId)) {
                        return;
                    }
                    this.processMessage(factory.getChatRoomById(roomId), message);
                }).start());
            });
        });
    }

    private boolean isPublic(ChatRoom r) {
        return r.getRoomName().equalsIgnoreCase("GENERAL") || !r.type().equals((Object)ChatRoom.Type.ONE_TO_ONE);
    }

    private void processMessage(RocketChatAPI.ChatRoom chatRoom, RocketChatMessage chatMessage) {
        String userId = chatMessage.getSender().getUserId();
        String message = chatMessage.getMessage();
        try {
            BotResponse response = this.queryApp(userId, message);
            if (response.type().equals((Object)BotResponse.Type.text) || response.type().equals((Object)BotResponse.Type.question)) {
                this.sendTextResponse(chatRoom, response);
            } else if (response.type().equals((Object)BotResponse.Type.multiline)) {
                this.sendMultilineResponse(chatRoom, response);
            } else if (response.type().equals((Object)BotResponse.Type.file)) {
                this.sendFile(chatRoom, userId, response);
            }
        }
        catch (RestfulFailure e) {
            Logger.error((String)e.getMessage());
            chatRoom.sendMessage("Error processing request: " + e.getMessage());
        }
    }

    private void sendTextResponse(RocketChatAPI.ChatRoom context, BotResponse botResponse) {
        context.sendMessage(String.format(botResponse.raw(), new Object[0]));
    }

    private void sendMultilineResponse(RocketChatAPI.ChatRoom context, BotResponse botResponse) {
        context.sendMessage(String.format(botResponse.raw(), new Object[0]));
    }

    private BotResponse queryApp(String userId, String message) throws RestfulFailure {
        RestAccessor.RestfulSecureConnection restAccessor = new RestAccessor().secure(this.urlOf(this.configuration.getProperty("federation.connectors.rocketChat.app.url")), userId);
        BotTalk talk = new BotTalk().conversation(message).timeZone(this.timeZone(userId));
        Response post = restAccessor.post(this.configuration.getProperty("federation.connectors.rocketChat.app.cliPath"), Json.toJson((Object)talk));
        return (BotResponse)Json.fromJson((String)post.content(), BotResponse.class);
    }

    private URL urlOf(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private void sendFile(RocketChatAPI.ChatRoom chatRoom, String userId, BotResponse response) {
        try {
            Path tempFile = Files.createTempFile(chatRoom.getRoomData().getRoomId() + "_" + userId + "_", response.fileName(), new FileAttribute[0]);
            Files.write(tempFile, Base64.decode((String)response.raw()), new OpenOption[0]);
            chatRoom.uploadFile(tempFile.toFile(), response.fileName(), response.title(), this.fileListener(tempFile));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String timeZone(String userId) {
        if (this.userTimeZones.containsKey(userId)) {
            return this.userTimeZones.get(userId);
        }
        try {
            User info = this.chatClient.getUsersApi().getInfo(userId);
            this.userTimeZones.put(userId, this.timeZone(info.getUtcOffset()));
            return this.userTimeZones.get(userId);
        }
        catch (IOException e) {
            return "Atlantic/Canary";
        }
    }

    private String timeZone(Integer offset) {
        if (offset == 0) {
            return "Z";
        }
        return (String)(offset > 0 ? "+" + String.format("%02d", offset) : String.format("%03d", offset)) + ":00";
    }

    private SubscribeListener emptySubscriber() {
        return (isSubscribed, subId) -> {};
    }

    public void onDisconnect(boolean closedByServer) {
        Logger.warn((String)("Disconnected. By server ->" + closedByServer));
    }

    public void onConnectError(Exception ex) {
        Logger.error((Throwable)ex);
        System.exit(-1);
    }

    private FileListener fileListener(final Path tempFile) {
        return new FileListener(){

            public void onUploadStarted(String s, String s1, String s2) {
            }

            public void onUploadProgress(int i, String s, String s1, String s2) {
            }

            public void onUploadComplete(int i, FileObject fileObject, String s, String s1, String s2) {
                tempFile.toFile().delete();
            }

            public void onUploadError(ErrorObject errorObject, IOException e) {
                tempFile.toFile().delete();
            }

            public void onSendFile(RocketChatMessage rocketChatMessage, ErrorObject errorObject) {
            }
        };
    }

    public static class ChatRoom
    extends Room {
        private final Room object;

        public ChatRoom(Room object) {
            super(ChatRoom.cover(object));
            this.object = object;
        }

        public String getRoomName() {
            return this.object.getRoomName().isEmpty() ? this.getRoomId() : this.object.getRoomName();
        }

        public String getRoomId() {
            return this.object.getRoomId();
        }

        public Type type() {
            return Type.valueOf(this.object.getRoomType().toString());
        }

        public UserObject getUserInfo() {
            return this.object.getUserInfo();
        }

        private static JSONObject cover(Room object) {
            try {
                return new JSONObject().put("_id", (Object)object.getRoomId()).put("t", (Object)"c");
            }
            catch (JSONException e) {
                return new JSONObject();
            }
        }

        public static enum Type {
            PUBLIC,
            PRIVATE,
            ONE_TO_ONE;

        }
    }
}

