/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.connectors.rocketchat;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ConfigurationReader {
    private final Properties configuration;

    public ConfigurationReader(File file) {
        this.configuration = this.read(file);
    }

    private String property(String name) {
        return this.configuration.getProperty(name);
    }

    private Properties read(File file) {
        Properties properties;
        Properties prop = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            prop.load(fis);
            properties = prop;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return prop;
            }
        }
        fis.close();
        return properties;
    }

    public String url() {
        return this.property("federation.connectors.rocketChat.url");
    }

    public URL appUrl() {
        try {
            return new URL(this.property("federation.connectors.rocketChat.app.url"));
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public String appCliPath() {
        return this.property("federation.connectors.rocketChat.app.cliPath");
    }

    public String botUser() {
        return this.property("federation.connectors.rocketChat.bot.user");
    }

    public String botPassword() {
        return this.property("federation.connectors.rocketChat.bot.password");
    }
}

