package io.intino.amidas.connectors.rocketchat;

import io.intino.alexandria.logger.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ConfigurationReader {
	private final Properties configuration;

	public ConfigurationReader(File file) {
		this.configuration = read(file);
	}

	private String property(String name) {
		return configuration.getProperty(name);
	}

	private Properties read(File file) {
		Properties prop = new Properties();
		try (FileInputStream fis = new FileInputStream(file)) {
			prop.load(fis);
			return prop;
		} catch (IOException e) {
			Logger.error(e);
			return prop;
		}
	}

	public String url() {
		return property("federation.connectors.rocketChat.url");
	}

	public URL appUrl() {
		try {
			return new URL(property("federation.connectors.rocketChat.app.url"));
		} catch (MalformedURLException e) {
			Logger.error(e);
			return null;
		}
	}

	public String appCliPath() {
		return property("federation.connectors.rocketChat.app.cliPath");
	}

	public String botUser() {
		return property("federation.connectors.rocketChat.bot.user");
	}

	public String botPassword() {
		return property("federation.connectors.rocketChat.bot.password");
	}

}