import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LoginTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LoginTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LoginTemplateNotifier(this);
		this.requester = new LoginTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a69616461" format="backgroundLogin" visible={false}>
				</UiImage>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1660567969" format="backgroundLogin backgroundDarkMode" visible={false}>
				</UiImage>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920" format="grey" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a_1357776555" layout="vertical flexible centercenter">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a_1357776555.a1656888149" mode="normal" value="Loading application...">
						</UiText>
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a_1357776555.a_1478660581" mode="Bar">
						</UiSpinner>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993" format="onTop" visible={false} layout="vertical" width="400px" height="360px" paper>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264" format="relative" layout="vertical flexible centerjustified" width="100.0%" height="100.0%" spacing="16">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264.a_461924550" layout="vertical centercenter">
								<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264.a_461924550.a_1441957139" width="-1px" height="70px" mobileReduceFactor={75}>
								</UiImage>
							</UiBlock>
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264.a457750170" label="Username" mode="normal" placeholder="Fill username" focused={true}>
							</UiTextEditable>
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264.a1940449375" label="Password" mode="normal" placeholder="Fill password" type="password">
							</UiTextEditable>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a577769264.a_837412156" format="loginError airTop" mode="normal">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a664706200" layout="vertical">
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a664706200.a80938252">
							</UiDivider>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1888951920.a609609993.a664706200.a1843353917" title="Log in" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginTemplate));
DisplayFactory.register("LoginTemplate", withStyles(styles, { withTheme: true })(withSnackbar(LoginTemplate)));