import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import FooterNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import FooterRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Footer extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new FooterNotifier(this);
		this.requester = new FooterRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="footerFormat" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1684913700" layout="horizontal flexible endjustified">
					<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1684913700.a988539021" title="powered by intino" target="blank" mode="Link" size="Medium" format="body2">
					</UiOpenSite>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Footer));
DisplayFactory.register("Footer", withStyles(styles, { withTheme: true })(withSnackbar(Footer)));