import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "platform-elements/gen/displays/templates/Header";
import DisplaysProfile from "platform-elements/gen/displays/templates/Profile";
import DisplaysFooter from "platform-elements/gen/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930" layout="vertical flexible">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_140267924" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_140267924.a_1942613271">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901" layout="horizontal" width="100.0%" height="100.0%">
						<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443" layout="vertical" width="200px" height="-1px" position="Left" variant="PersistentAndMini">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_410529179" layout="horizontal endjustified center" width="-1px" height="60px">
								<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_410529179.a103731529" title="open menu" target="self" mode="MaterialIconButton" icon="ChevronRight" size="Medium" format="airMenuRight">
								</UiOpenDrawer>
								<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_410529179.a32286771" title="minimize" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium" format="airMenuRight">
								</UiCloseDrawer>
							</UiBlock>
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a1136416836">
							</UiDivider>
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_2035864316" multipleSelection={false}>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_2035864316.a_1034282642" name="profile" layout="horizontal" spacing="16">
									<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_2035864316.a_1034282642.a_1168307362" icon="PermIdentity">
									</UiMaterialIcon>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a1856834443.a_2035864316.a_1034282642.a1778026383" mode="normal" translate={true} value="Profile">
									</UiText>
								</UiBlock>
							</UiSelectorListBox>
						</UiBlockDrawer>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a269517697" layout="vertical flexible centercenter">
								<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a269517697.a_224497964" format="secondary" mode="Rise">
								</UiSpinner>
							</UiBlock>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a_574596195" layout="vertical flexible">
								<DisplaysProfile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a_574596195.a_1596358404">
								</DisplaysProfile>
							</UiBlockConditional>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a381459313" layout="vertical">
								<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1195453930.a_1780086901.a_1261793716.a381459313.a_919404931">
								</DisplaysFooter>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));