import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"pt" : {
			"Affirm" : "Confirmar",
			"Sign" : "Firmar",
			"Cancel" : "Cancelar",
			"OK" : "Aceitar",
			"Back" : "Anterior",
			"Logout" : "Cerrar sessão",
			"Next" : "Siguiente",
			"Value is out of range" : "Valor não permitido",
			"Search..." : "Buscar...",
			"no results" : "sem elementos de feno",
			"one result" : "un resultado",
			"results" : "resultados",
			"User not granted to execute operation" : "Permissão negada. Não pode executar a operação",
			"Value is out of range" : "Valor não permitido",
			"User unknown" : "Usuario desconocido",
			"Loading application..." : "Cargando aplicativo...",
			"Starting application..." : "Iniciando aplicação...",
			"Fill username" : "Insira seu nome de usuário",
			"Username" : "nome de usuário",
			"Fill password" : "Insira sua senha",
			"Password" : "Senha",
			"Log in" : "Iniciar sessão",
			"Fill valid username" : "Preencha um nome de usuário válido",
			"Wrong password" : "Senha incorreta",
			"User unknown" : "Usuário não encontrado",
			"Profile" : "Perfil",
			"Under construction" : "Em construção"
		},
		"es" : {
			"Affirm" : "Confirmar",
			"Sign" : "Firmar",
			"Cancel" : "Cancelar",
			"OK" : "Aceptar",
			"Back" : "Anterior",
			"Logout" : "Cerrar sesión",
			"Next" : "Siguiente",
			"Value is out of range" : "Valor no permitido",
			"Search..." : "Buscar...",
			"no results" : "no hay elementos",
			"one result" : "un resultado",
			"results" : "resultados",
			"User not granted to execute operation" : "Permiso denegado. No puede ejecutar la operación",
			"Value is out of range" : "Valor no permitido",
			"User unknown" : "Usuario desconocido",
			"Loading application..." : "Cargando aplicación...",
			"Starting application..." : "Iniciando aplicación...",
			"Fill username" : "Indique su nombre de usuario",
			"Username" : "Nombre de usuario",
			"Fill password" : "Indique su contraseña",
			"Password" : "Contraseña",
			"Log in" : "Iniciar sesión",
			"Fill valid username" : "Indique un nombre de usuario válido",
			"Wrong password" : "Contraseña incorrecta",
			"User unknown" : "Usuario no encontrado",
			"Profile" : "Perfil",
			"Under construction" : "En construcción"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;