import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractAdmin from "../../../gen/displays/templates/AbstractAdmin";
import AdminNotifier from "../../../gen/displays/notifiers/AdminNotifier";
import AdminRequester from "../../../gen/displays/requesters/AdminRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Admin extends AbstractAdmin {

	constructor(props) {
		super(props);
		this.notifier = new AdminNotifier(this);
		this.requester = new AdminRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Admin));
DisplayFactory.register("Admin", withStyles(styles, { withTheme: true })(withSnackbar(Admin)));