import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"mx" : {
			"Affirm" : "Confirmar",
			"Sign" : "Firmar",
			"Cancel" : "Cancelar",
			"OK" : "Aceptar",
			"Back" : "Anterior",
			"Logout" : "Cerrar sesión",
			"Next" : "Siguiente",
			"Value is out of range" : "Valor no permitido",
			"Search..." : "Buscar...",
			"no results" : "no hay elementos",
			"one result" : "un resultado",
			"results" : "resultados",
			"User not granted to execute operation" : "Permiso denegado. No puede ejecutar la operación",
			"Value is out of range" : "Valor no permitido",
			"User unknown" : "Usuario desconocido",
			"Loading application..." : "Cargando aplicación...",
			"Starting application..." : "Iniciando aplicación..."
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;