import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ProfileRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Profile extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileNotifier(this);
		this.requester = new ProfileRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_614210561" format="air" layout="vertical flexible centercenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_614210561.a_808831509" mode="normal" value="En construcción">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Profile));
DisplayFactory.register("Profile", withStyles(styles, { withTheme: true })(withSnackbar(Profile)));