import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "platform-elements/src/displays/templates/Header";
import DisplaysProfile from "platform-elements/src/displays/templates/Profile";
import DisplaysFooter from "platform-elements/src/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractHomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a766731090" layout="vertical flexible">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2065608807" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1942613271">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1096355764" layout="horizontal" width="100.0%" height="100.0%">
						<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1856834443" layout="vertical" width="200px" height="-1px" position="Left" variant="PersistentAndMini">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_670992391" layout="horizontal endjustified center" width="-1px" height="60px">
								<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_234295947" title="open menu" target="self" mode="MaterialIconButton" icon="ChevronRight" size="Medium" format="airMenuRight">
								</UiOpenDrawer>
								<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a159929991" title="minimize" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium" format="airMenuRight">
								</UiCloseDrawer>
							</UiBlock>
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a875953624">
							</UiDivider>
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2035864316" multipleSelection={false}>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1034282642" name="profile" layout="horizontal" spacing="16">
									<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_387039054" icon="PermIdentity">
									</UiMaterialIcon>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1766646069" mode="normal" value="Profile">
									</UiText>
								</UiBlock>
							</UiSelectorListBox>
						</UiBlockDrawer>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_139709864" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a269517697" layout="vertical flexible centercenter">
								<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1279882776" format="secondary" mode="Rise">
								</UiSpinner>
							</UiBlock>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_574596195" layout="vertical flexible">
								<DisplaysProfile context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1596358404">
								</DisplaysProfile>
							</UiBlockConditional>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2033171048" layout="vertical">
								<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_919404931">
								</DisplaysFooter>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}