import { createMuiTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
		create: () => {
			theme = createMuiTheme({
				palette : {
				    primary : { main: "#188564" },
				    secondary : { main: "#ff9100" },
				    error : { main: "#f44336" },
				    contrastThreshold : "3",
				    tonalOffset : "0.2",
				    grey : {
				    	primary: "#888",
				    	secondary: '#ddd'
				    }
				},
				typography : {
				    fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
				    fontSize : 13,
				    useNextVariants: true
				},
				formats: {
				    h1: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'25pt' },
				    h2: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'20pt' },
				    h3: { fontSize:'15pt' },
				    h4: { fontSize:'14pt',fontWeight:'400' },
				    h5: { fontSize:'12pt' },
				    h6: { lineHeight:'17pt',fontSize:'12pt' },
				    body1: {  },
				    body2: {  },
				    subtitle1: {  },
				    subtitle2: {  },
				    relative: { position:'relative' },
				    grey: { background:'#efefef' },
				    onTop: { zIndex:'1' },
				    secondary: {  },
				    footerFormat: { background:'#efefef',padding:'1px 7px',borderTop:'1px solid #aaa' },
				    airTop: { marginTop:'10px' },
				    middleAirTop: { marginTop:'5px' },
				    airBottom: { marginBottom:'10px' },
				    airRight: { marginRight:'10px' },
				    air: { padding:'10px' },
				    airMenuRight: { marginRight:'4px' },
				    minWidth: { minWidth:'400px' },
				    whiteBackground: { background:'white',borderRadius:'3px',height:'100%',border:'1px solid #efefef' },
				    description: { fontSize:'10pt',color:'grey' },
				    propertyValue: { wordBreak:'break-all' },
				    backgroundLogin: { position:'absolute',bottom:'0',top:'0',width:'100%',height:'100%',zIndex:'0',objectFit:'none' },
				    backgroundDarkMode: { backgroundColor:'black' },
				    loginError: { position:'absolute',bottom:'-10px',textAlign:'center',width:'100%',color:'red' },
				    airHeader: { padding:'4px 20px' },
				    separator: { borderBottom:'1px solid #ddd',width:'100%' }
				}
			});
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

export default Theme;