package io.intino.amidas.connectors.microsoft.azure;

import io.intino.alexandria.logger.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class CredentialReader {
	private final Properties credentials;

	public CredentialReader(File file) {
		this.credentials = read(file);
	}

	private String property(String name) {
		return credentials.getProperty(name);
	}

	private Properties read(File file) {
		Properties prop = new Properties();
		try (FileInputStream fis = new FileInputStream(file)) {
			prop.load(fis);
			return prop;
		} catch (IOException e) {
			Logger.error(e);
			return prop;
		}
	}

	public String tenantId() {
		return property("tenantId");
	}

	public String clientId() {
		return property("clientId");
	}

	public String secret() {
		return property("clientSecret");
	}
}