package io.intino.amidas.connectors.microsoft.azure;

import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import io.intino.amidas.connectors.microsoft.azure.model.User;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ActiveDirectoryAccessor {
	private final List<User> users = Collections.synchronizedList(new ArrayList<>());
	private final CredentialReader credentialReader;

	public ActiveDirectoryAccessor(File credentialsFile) {
		credentialReader = new CredentialReader(credentialsFile);
	}

	public List<User> users() {
		return users;
	}

	public User user(String id) {
		return users.stream().filter(f -> id.equals(f.id)).findFirst().orElse(null);
	}

	public void refresh() {
		final GraphServiceClient<?> graphClient = GraphServiceClient
				.builder()
				.authenticationProvider(getAuth())
				.buildClient();
		UserCollectionRequestBuilder request = graphClient.users();
		UserCollectionPage page = request.buildRequest().get();
		List<User> users = new ArrayList<>();
		if (page != null) users.addAll(map(page.getCurrentPage()));
		while (page != null && (request = page.getNextPage()) != null) {
			page = request.buildRequest().get();
			if (page != null) users.addAll(map(page.getCurrentPage()));
		}
		this.users.clear();
		this.users.addAll(users);
	}

	private List<User> map(List<com.microsoft.graph.models.User> users) {
		return users.stream().map(u -> new User(u.id, u.displayName, u.givenName, u.mail, u.preferredLanguage)).collect(Collectors.toList());
	}

	@NotNull
	private TokenCredentialAuthProvider getAuth() {
		return new TokenCredentialAuthProvider(new ClientSecretCredentialBuilder()
				.tenantId(credentialReader.tenantId())
				.clientId(credentialReader.clientId())
				.clientSecret(credentialReader.secret())
				.build());
	}

}
