import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractTeamTemplate from "../../../gen/displays/templates/AbstractTeamTemplate";
import TeamTemplateNotifier from "../../../gen/displays/notifiers/TeamTemplateNotifier";
import TeamTemplateRequester from "../../../gen/displays/requesters/TeamTemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TeamTemplate extends AbstractTeamTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TeamTemplateNotifier(this);
		this.requester = new TeamTemplateRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TeamTemplate));
DisplayFactory.register("TeamTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TeamTemplate)));