import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractTeam from "../../../gen/displays/templates/AbstractTeam";
import TeamNotifier from "../../../gen/displays/notifiers/TeamNotifier";
import TeamRequester from "../../../gen/displays/requesters/TeamRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Team extends AbstractTeam {

	constructor(props) {
		super(props);
		this.notifier = new TeamNotifier(this);
		this.requester = new TeamRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Team));
DisplayFactory.register("Team", withStyles(styles, { withTheme: true })(withSnackbar(Team)));