import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractPropertyEditor from "../../../gen/displays/templates/AbstractPropertyEditor";
import PropertyEditorNotifier from "../../../gen/displays/notifiers/PropertyEditorNotifier";
import PropertyEditorRequester from "../../../gen/displays/requesters/PropertyEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PropertyEditor extends AbstractPropertyEditor {

	constructor(props) {
		super(props);
		this.notifier = new PropertyEditorNotifier(this);
		this.requester = new PropertyEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(PropertyEditor));
DisplayFactory.register("PropertyEditor", withStyles(styles, { withTheme: true })(withSnackbar(PropertyEditor)));