import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractExpandedPropertyEditor from "../../../gen/displays/templates/AbstractExpandedPropertyEditor";
import ExpandedPropertyEditorNotifier from "../../../gen/displays/notifiers/ExpandedPropertyEditorNotifier";
import ExpandedPropertyEditorRequester from "../../../gen/displays/requesters/ExpandedPropertyEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ExpandedPropertyEditor extends AbstractExpandedPropertyEditor {

	constructor(props) {
		super(props);
		this.notifier = new ExpandedPropertyEditorNotifier(this);
		this.requester = new ExpandedPropertyEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ExpandedPropertyEditor));
DisplayFactory.register("ExpandedPropertyEditor", withStyles(styles, { withTheme: true })(withSnackbar(ExpandedPropertyEditor)));