import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractExpandedDefinitionEditor from "../../../gen/displays/templates/AbstractExpandedDefinitionEditor";
import ExpandedDefinitionEditorNotifier from "../../../gen/displays/notifiers/ExpandedDefinitionEditorNotifier";
import ExpandedDefinitionEditorRequester from "../../../gen/displays/requesters/ExpandedDefinitionEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ExpandedDefinitionEditor extends AbstractExpandedDefinitionEditor {

	constructor(props) {
		super(props);
		this.notifier = new ExpandedDefinitionEditorNotifier(this);
		this.requester = new ExpandedDefinitionEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ExpandedDefinitionEditor));
DisplayFactory.register("ExpandedDefinitionEditor", withStyles(styles, { withTheme: true })(withSnackbar(ExpandedDefinitionEditor)));