import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractDefinitionEditor from "../../../gen/displays/templates/AbstractDefinitionEditor";
import DefinitionEditorNotifier from "../../../gen/displays/notifiers/DefinitionEditorNotifier";
import DefinitionEditorRequester from "../../../gen/displays/requesters/DefinitionEditorRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DefinitionEditor extends AbstractDefinitionEditor {

	constructor(props) {
		super(props);
		this.notifier = new DefinitionEditorNotifier(this);
		this.requester = new DefinitionEditorRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DefinitionEditor));
DisplayFactory.register("DefinitionEditor", withStyles(styles, { withTheme: true })(withSnackbar(DefinitionEditor)));