package io.intino.amidas.identityeditor.box.ui.resources;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.pages.PropertyEditorProxyPage;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;

import java.util.function.Function;

public class PropertyEditorProxyResource extends io.intino.alexandria.ui.spark.resources.ProxyResource {
	private final IdentityEditorBox box;

	public PropertyEditorProxyResource(IdentityEditorBox box, io.intino.alexandria.ui.spark.UISparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
		this.box = box;
	}

	@Override
	public void execute() throws AlexandriaException {
		fillBrowser(manager, session());
		fillDeviceParameter();
		try {
			if (!isLogged(accessToken()))
				throw new Unauthorized("user is not logged");

			authenticate(session(), accessToken());
			render();
		} catch (CouldNotObtainInfo couldNotObtainInfo) {
			throw new Unauthorized("user is not logged");
		} catch (Throwable error) {
			throw new Unauthorized("could not render component");
		}
	}

	private void render() {
		UIClient client = client();

		PropertyEditorProxyPage page = new PropertyEditorProxyPage();
		page.session = session();
		page.session.browser().onRedirect(location -> manager.redirect(location));
		page.session.browser().requestUrl(manager.requestUrl());
		page.session.whenLogin(new Function<String, String>() {
			@Override
			public String apply(String baseUrl) {
				return PropertyEditorProxyResource.this.authenticate(page.session, baseUrl);
			}
		});
		page.session.whenLogout(b -> logout(page.session));
		page.box = box;
		page.clientId = client.id();
		page.googleApiKey = "";
		page.device = parameterValue("device");
		page.personifiedDisplay = parameterValue("personifiedDisplay");
        if (!page.hasPermissions()) {
            manager.redirect(page.redirectUrl());
            return;
        }

		Soul soul = soul();
		if (soul != null) {
			page.soul = soul;
			page.execute();
			return;
		}

		soul = new Soul(page.session) {
			@Override
			public void personify() {
				Soul soul = this;
				addRegisterDisplayListener(display -> {
					display.inject(notifier(page.session, client, display));
					display.inject(page.session);
					display.inject(soul);
					display.inject(() -> soul);
				});
			}
		};
		client.soul(soul);
		page.soul = soul;
		page.execute();
		box.registerSoul(client.id(), soul);
		soul.register(new io.intino.alexandria.ui.displays.DisplayRouter(box).id("__router__"));
		//((io.intino.amidas.identityeditor.box.ui.displays.RouteDispatcher)box.routeManager().routeDispatcher()).dispatchPropertyEditor(soul, page.personifiedDisplay);

		manager.write("OK");
	}
}