package io.intino.amidas.identityeditor.box.ui.pages;

import io.intino.alexandria.exceptions.*;
import java.time.*;
import java.util.*;

import io.intino.amidas.identityeditor.box.ui.TeamHelper;
import io.intino.amidas.identityeditor.box.ui.displays.templates.*;

public class TeamPage extends AbstractTeamPage {

	@Override
	public boolean hasPermissions() {
		return TeamHelper.isIdentityManager(box, session.user());
	}

	@Override
	public String redirectUrl() {
		return session.browser().baseUrl() + "/error";
	}

	public io.intino.alexandria.ui.Soul prepareSoul(io.intino.alexandria.ui.services.push.UIClient client) {
	    return new io.intino.alexandria.ui.Soul(session) {
			@Override
			public void personify() {
				TeamTemplate component = new TeamTemplate(box);
				register(component);
				component.init();
			}
		};
	}
}