package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.identity.IdentityCommands;

import java.util.Timer;
import java.util.TimerTask;

public class TeamTemplate extends AbstractTeamTemplate<IdentityEditorBox> {

    public TeamTemplate(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        teamEditorPage.teamEditorStamp.team(box().team());
        teamEditorPage.teamEditorStamp.onModifyIdentity((identity, statements) -> box().commands(IdentityCommands.class).saveIdentity(identity, statements, username()));
        teamEditorPage.teamEditorStamp.filter("");
        teamEditorPage.teamEditorStamp.refresh();
    }

    public void reloadTeam() {
        teamEditorPage.teamEditorStamp.reloadTeam(box().team());
	}
}