package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.identity.IdentityCommands;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.Team.Identity;

import java.util.List;
import java.util.stream.Collectors;

public class ProfileTemplate extends AbstractProfileTemplate<IdentityEditorBox> {

    public ProfileTemplate(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        Identity identity = findIdentity();
        List<Property> properties = box().team().grammar().getAll().stream().filter(p -> p.isIdentifier() || p.isFeature()).collect(Collectors.toList());
        profileEditorPage.profileEditorStamp.identity(identity, properties);
        profileEditorPage.profileEditorStamp.onModifyIdentity((i, statements) -> box().commands(IdentityCommands.class).saveIdentity(i, statements, username()));
        profileEditorPage.profileEditorStamp.refresh();
    }

    private Identity findIdentity() {
        Team team = box().team();
        String username = username();
        if (username == null) return team.createIdentity();
        List<Identity> result = team.search(username);
        return result.size() > 0 ? result.get(0) : team.createIdentity();
    }

}