package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.zif.grammar.Property;
import io.intino.amidas.shared.Team;
import io.intino.amidas.shared.Team.Identity;

import java.util.List;

public class IdentityDialog extends AbstractIdentityDialog<Box> {
    private Identity identity;
    private List<Property> properties;

    public IdentityDialog(Box box) {
        super(box);
    }

    public IdentityDialog identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public List<Team.Statement> statements() {
        return identityEditor.statements();
    }

    public IdentityDialog properties(List<Property> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        identityEditor.properties(properties);
        identityEditor.identity(identity);
        identityEditor.refresh();
    }

}