package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.logger.Logger;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;

import java.io.File;
import java.net.MalformedURLException;

public class Header extends AbstractHeader<IdentityEditorBox> {

    public Header(IdentityEditorBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        initLogo();
        title.value(box().configuration().title());
        String subtitle = box().configuration().subtitle();
        this.subtitle.visible(subtitle == null || subtitle.isEmpty());
        if (this.subtitle.isVisible()) this.subtitle.value(subtitle);
    }

    private void initLogo() {
        try {
            logo.value(new File(box().configuration().logo()).toPath().toUri().toURL());
        } catch (MalformedURLException e) {
            Logger.error(e);
        }
    }
}