package io.intino.amidas.identityeditor.box.ui.displays.templates;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.ui.displays.components.*;
import io.intino.amidas.identityeditor.box.ui.*;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;

import io.intino.amidas.identityeditor.box.ui.displays.templates.*;



import io.intino.amidas.identityeditor.box.ui.displays.notifiers.PropertyViewerNotifier;

public abstract class AbstractPropertyViewer<B extends Box> extends io.intino.alexandria.ui.displays.components.Template<PropertyViewerNotifier, java.lang.Void, B> {
	public Property property;
	public StringType stringType;
	public PropertyViewer.StringType. StringValue stringValue;
	public ImageType imageType;
	public PropertyViewer.ImageType. ImageValue imageValue;

    public AbstractPropertyViewer(B box) {
        super(box);
        id("propertyViewer");
    }

    @Override
	public void init() {
		super.init();
		if (property == null) property = register(new Property(box()).<Property>id("a1495460750").owner(AbstractPropertyViewer.this));
		if (stringType == null) stringType = register(new StringType(box()).<StringType>id("a1971680868").owner(AbstractPropertyViewer.this));
		if (stringType != null) stringValue = stringType.stringValue;
		if (imageType == null) imageType = register(new ImageType(box()).<ImageType>id("a_1040895844").owner(AbstractPropertyViewer.this));
		if (imageType != null) imageValue = imageType.imageValue;
	}

	public class Property extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

		public Property(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
		}
	}

	public class StringType extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
		public PropertyViewer.StringType. StringValue stringValue;

		public StringType(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (stringValue == null) stringValue = register(new StringValue(box()).<StringValue>id("a1720844933").owner(AbstractPropertyViewer.this));
		}

		public class StringValue extends io.intino.alexandria.ui.displays.components.Text<io.intino.alexandria.ui.displays.notifiers.TextNotifier, B>  {

			public StringValue(B box) {
				super(box);
			}

			@Override
			public void init() {
				super.init();
			}
		}
	}

	public class ImageType extends io.intino.alexandria.ui.displays.components.Block<io.intino.alexandria.ui.displays.notifiers.BlockNotifier, B>  {
		public PropertyViewer.ImageType. ImageValue imageValue;

		public ImageType(B box) {
			super(box);
		}

		@Override
		public void init() {
			super.init();
			if (imageValue == null) imageValue = register(new ImageValue(box()).<ImageValue>id("a_863665063").owner(AbstractPropertyViewer.this));
		}

		public class ImageValue extends io.intino.alexandria.ui.displays.components.Image<io.intino.alexandria.ui.displays.notifiers.ImageNotifier, B>  {

			public ImageValue(B box) {
				super(box);
			}

			@Override
			public void init() {
				super.init();
			}
		}
	}
}