package io.intino.amidas.identityeditor.box.handlers;

import io.intino.alexandria.Base64;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.DisplayRouteDispatcher;
import io.intino.amidas.datahub.events.Identities;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.ui.displays.RouteDispatcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class IdentitiesHandler {
	private IdentityEditorBox box;

	public IdentitiesHandler(IdentityEditorBox box) {
		this.box = box;
	}

	public void handle(Identities event) {
		try {
			File file = new File(box.configuration().identitiesFile());
			if (file.exists()) file.delete();
			Files.write(file.getAbsoluteFile().toPath(), Base64.decode(event.zif()));
			box.reloadTeam();
		} catch (IOException e) {
			Logger.error(e);
		}
	}

}
