package io.intino.amidas.identityeditor.box.commands.identity;

import io.intino.alexandria.Base64;
import io.intino.alexandria.logger.Logger;
import io.intino.amidas.datahub.events.Identities;
import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.Command;
import io.intino.amidas.shared.Team;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;

public class SaveIdentityCommand extends Command<Team.Identity> {
	public Team.Identity identity;
	public List<Team.Statement> statements;

	public SaveIdentityCommand(IdentityEditorBox box) {
		super(box);
	}

	@Override
	public Team.Identity execute() {
		Identities identities = buildSchema();
		if (identities == null) {
			Logger.error("SaveIdentityCommand: Could not create schema");
		}
		feed(identities);
		return identity;
	}

	private Identities buildSchema() {
		Path temporalFile = null;
		try {
			temporalFile = Files.createTempFile(identifiesFilename() + "_", ".zif");
			Path path = new File(box.configuration().identitiesFile()).toPath();
			Files.copy(path, temporalFile, StandardCopyOption.REPLACE_EXISTING);
			Team team = new Team(temporalFile.toFile());
			Team.Builder builder = team.build(identity);
			statements.forEach(builder::append);
			builder.save();
			return setup(new Identities()).zif(Base64.encode(Files.readAllBytes(temporalFile)));
		} catch (IOException e) {
			Logger.error(e);
			return null;
		}
		finally {
			if (temporalFile != null) temporalFile.toFile().delete();
		}
	}

	private String identifiesFilename() {
		File current = new File(box.configuration().identitiesFile());
		return current.getName().substring(0, current.getName().lastIndexOf("."));
	}

}