package io.intino.amidas.identityeditor.box.commands;

import io.intino.amidas.identityeditor.box.IdentityEditorBox;
import io.intino.amidas.identityeditor.box.commands.identity.IdentityCommands;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CommandsFactory {
	private final IdentityEditorBox box;

	private static Map<Class<? extends Commands>, Function<IdentityEditorBox, ? extends Commands>> builder = new HashMap<>();

	public CommandsFactory(IdentityEditorBox box) {
		this.box = box;
		buildCommands();
	}

	private void buildCommands() {
		builder.put(IdentityCommands.class, IdentityCommands::new);
	}

	public <T extends Commands> T command(Class<T> clazz) {
		return (T) builder.get(clazz).apply(box);
	}

}
