package io.intino.amidas.identityeditor.box;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.amidas.identityeditor.box.commands.Commands;
import io.intino.amidas.identityeditor.box.commands.CommandsFactory;
import io.intino.amidas.identityeditor.box.mounters.MounterFactory;
import io.intino.amidas.shared.Team;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class IdentityEditorBox extends AbstractBox {
	private CommandsFactory commandsFactory;
	private MounterFactory mounterFactory;
	private Team team;

	public IdentityEditorBox(String[] args) {
		super(args);
	}

	public IdentityEditorBox(IdentityEditorConfiguration configuration) {
		super(configuration);
	}

	@Override
	public io.intino.alexandria.core.Box put(Object o) {
		super.put(o);
		return this;
	}

	public <F extends Commands> F commands(Class<F> clazz) {
		return commandsFactory.command(clazz);
	}

	@Override
	public void beforeStart() {
		this.commandsFactory = new CommandsFactory(this);
		this.mounterFactory = new MounterFactory(this);
		this.team = createTeam();
	}

	public MounterFactory mounterFactory() {
		return mounterFactory;
	}

	public Team team() {
		return team;
	}

	@Override
	public void afterStart() {

	}

	public io.intino.alexandria.core.Box start() {
		return super.start();
	}

	@Override
	public void beforeStop() {

	}

	@Override
	public void afterStop() {

	}

	@Override
	protected AuthService authService(URL authServiceUrl) {
		try {
			if (authServiceUrl == null) return null;
			return new AmidasOauthAccessor(new Space(new URL(configuration().url())), authServiceUrl);
		} catch (MalformedURLException e) {
			Logger.error(e);
			return null;
		}
	}

	public void reloadTeam() {
		this.team = createTeam();
	}

	private Team createTeam() {
		try {
			File file = new File(configuration().identitiesFile());
			return file.exists() ? new Team(file) : null;
		} catch (IOException e) {
			Logger.error(e);
			return null;
		}
	}
}