import React from "react";
import UiStamp from "alexandria-ui-elements/src/displays/components/Stamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import DisplaysHeader from "identity-editor-elements/src/displays/templates/Header";
import DisplaysTeamEditor from "identity-editor-elements/src/displays/templates/TeamEditor";
import DisplaysFooter from "identity-editor-elements/src/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractTeamTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1114565545" layout="vertical" width="100.0%" height="100.0%">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1301797242" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a225790729">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1425741274" layout="vertical flexible">
						<DisplaysTeamEditor context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1206846560">
						</DisplaysTeamEditor>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a479355374" layout="vertical">
						<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a346174330">
						</DisplaysFooter>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}